/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.ClassIdentifier;
import bsh.ClassNameSpace;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class Name
implements Serializable {
    public NameSpace namespace;
    String value = null;
    private String evalName;
    private String lastEvalName;
    private static String FINISHED = null;
    private Object evalBaseObject;
    private int callstackDepth;
    Class asClass;
    Class classOfStaticMethod;

    private void reset() {
        this.evalName = this.value;
        this.evalBaseObject = null;
        this.callstackDepth = 0;
    }

    Name(NameSpace nameSpace, String string2) {
        this.namespace = nameSpace;
        this.value = string2;
    }

    public Object toObject(CallStack callStack, Interpreter interpreter) throws UtilEvalError {
        return this.toObject(callStack, interpreter, false);
    }

    public synchronized Object toObject(CallStack callStack, Interpreter interpreter, boolean bl) throws UtilEvalError {
        this.reset();
        Object object = null;
        while (this.evalName != null) {
            object = this.consumeNextObjectField(callStack, interpreter, bl, false);
        }
        if (object == null) {
            throw new InterpreterError("null value in toObject()");
        }
        return object;
    }

    private Object completeRound(String string2, String string3, Object object) {
        this.lastEvalName = string2;
        this.evalName = string3;
        this.evalBaseObject = object;
        return object;
    }

    private Object consumeNextObjectField(CallStack callStack, Interpreter interpreter, boolean bl, boolean bl2) throws UtilEvalError {
        Object object;
        Object object2;
        if (this.evalBaseObject == null && !Name.isCompound(this.evalName) && !bl && (object2 = this.resolveThisFieldReference(callStack, this.namespace, interpreter, this.evalName, false)) != Primitive.VOID) {
            return this.completeRound(this.evalName, FINISHED, object2);
        }
        if ((this.evalBaseObject == null || this.evalBaseObject instanceof This) && !bl) {
            Object object3;
            object2 = Name.prefix(this.evalName, 1);
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying to resolve variable: " + (String)object2);
            }
            if ((object3 = this.evalBaseObject == null ? this.resolveThisFieldReference(callStack, this.namespace, interpreter, (String)object2, false) : this.resolveThisFieldReference(callStack, ((This)this.evalBaseObject).namespace, interpreter, (String)object2, true)) == Primitive.VOID && bl2) {
                object = this.evalBaseObject == null ? this.namespace : ((This)this.evalBaseObject).namespace;
                object3 = new NameSpace((NameSpace)object, "auto: " + (String)object2).getThis(interpreter);
                ((NameSpace)object).setVariable((String)object2, object3, false);
            }
            if (object3 != Primitive.VOID) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("resolved variable: " + (String)object2 + " in namespace: " + this.namespace);
                }
                return this.completeRound((String)object2, Name.suffix(this.evalName), object3);
            }
        }
        if (this.evalBaseObject == null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying class: " + this.evalName);
            }
            object2 = null;
            int n = 1;
            object = null;
            while (n <= Name.countParts(this.evalName)) {
                object = Name.prefix(this.evalName, n);
                object2 = this.namespace.getClass((String)object);
                if (object2 != null) break;
                ++n;
            }
            if (object2 != null) {
                return this.completeRound((String)object, Name.suffix(this.evalName, Name.countParts(this.evalName) - n), new ClassIdentifier((Class)object2));
            }
            if (Interpreter.DEBUG) {
                Interpreter.debug("not a class, trying var prefix " + this.evalName);
            }
        }
        if (this.evalBaseObject == null) {
            if (!Name.isCompound(this.evalName)) {
                return this.completeRound(this.evalName, FINISHED, Primitive.VOID);
            }
            throw new UtilEvalError("Class or variable not found: " + this.evalName);
        }
        if (this.evalBaseObject == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Null Pointer while evaluating: " + this.value));
        }
        if (this.evalBaseObject == Primitive.VOID) {
            throw new UtilEvalError("Undefined variable or class name while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof Primitive) {
            throw new UtilEvalError("Can't treat primitive like an object. Error while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof ClassIdentifier) {
            String string2;
            Class clazz;
            String string3;
            block26: {
                object2 = ((ClassIdentifier)this.evalBaseObject).getTargetClass();
                string3 = Name.prefix(this.evalName, 1);
                object = null;
                try {
                    if (Interpreter.DEBUG) {
                        Interpreter.debug("Name call to getStaticField, class: " + object2 + ", field:" + string3);
                    }
                    object = Reflect.getStaticField((Class)object2, string3);
                }
                catch (ReflectError reflectError) {
                    if (!Interpreter.DEBUG) break block26;
                    Interpreter.debug("field reflect error: " + reflectError);
                }
            }
            if (object == null && (clazz = this.namespace.getClass(string2 = ((Class)object2).getName() + "$" + string3)) != null) {
                object = new ClassIdentifier(clazz);
            }
            if (object == null) {
                throw new UtilEvalError("No static field or inner class: " + string3 + " of " + object2);
            }
            return this.completeRound(string3, Name.suffix(this.evalName), object);
        }
        if (bl) {
            throw new UtilEvalError(this.value + " does not resolve to a class name.");
        }
        object2 = Name.prefix(this.evalName, 1);
        if (((String)object2).equals("length") && this.evalBaseObject.getClass().isArray()) {
            Primitive primitive = new Primitive(Array.getLength(this.evalBaseObject));
            return this.completeRound((String)object2, Name.suffix(this.evalName), primitive);
        }
        try {
            Object object4 = Reflect.getObjectField(this.evalBaseObject, (String)object2);
            return this.completeRound((String)object2, Name.suffix(this.evalName), object4);
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Cannot access field: " + (String)object2 + ", on object: " + this.evalBaseObject);
        }
    }

    Object resolveThisFieldReference(CallStack callStack, NameSpace nameSpace, Interpreter interpreter, String string2, boolean bl) throws UtilEvalError {
        Object object = null;
        if (string2.equals("this")) {
            if (bl) {
                throw new UtilEvalError("Redundant to call .this on This type");
            }
            This this_ = nameSpace.getThis(interpreter);
            nameSpace = this_.getNameSpace();
            if (nameSpace.isMethod && nameSpace.getParent() != null && nameSpace.getParent() instanceof ClassNameSpace && ((ClassNameSpace)nameSpace.getParent()).isClassInstance()) {
                this_ = nameSpace.getParent().getThis(interpreter);
            }
            return this_;
        }
        if (string2.equals("super")) {
            This this_ = nameSpace.getSuper().getThis(interpreter);
            if ((nameSpace = this_.getNameSpace()) instanceof ClassNameSpace && ((ClassNameSpace)nameSpace).isClassInstance() && nameSpace.getParent() != null && nameSpace.getParent() instanceof ClassNameSpace && ((ClassNameSpace)nameSpace.getParent()).isClassInstance()) {
                this_ = nameSpace.getParent().getThis(interpreter);
            }
            return this_;
        }
        if (string2.equals("global")) {
            object = nameSpace.getGlobal().getThis(interpreter);
        }
        if (object == null && bl) {
            if (string2.equals("namespace")) {
                object = nameSpace;
            } else if (string2.equals("variables")) {
                object = nameSpace.getVariableNames();
            } else if (string2.equals("methods")) {
                object = nameSpace.getMethodNames();
            } else if (string2.equals("interpreter")) {
                if (this.lastEvalName.equals("this")) {
                    object = interpreter;
                } else {
                    throw new UtilEvalError("Can only call .interpreter on literal 'this'");
                }
            }
        }
        if (object == null && bl && string2.equals("caller")) {
            if (this.lastEvalName.equals("this") || this.lastEvalName.equals("caller")) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
            } else {
                throw new UtilEvalError("Can only call .caller on literal 'this' or literal '.caller'");
            }
            object = callStack.get(++this.callstackDepth).getThis(interpreter);
            return object;
        }
        if (object == null && bl && string2.equals("callstack")) {
            if (this.lastEvalName.equals("this")) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
                object = callStack;
            } else {
                throw new UtilEvalError("Can only call .callstack on literal 'this'");
            }
        }
        if (object == null) {
            object = nameSpace.getVariable(string2);
        }
        return object;
    }

    public synchronized Class toClass() throws ClassNotFoundException, UtilEvalError {
        if (this.asClass != null) {
            return this.asClass;
        }
        this.reset();
        if (this.evalName.equals("var")) {
            this.asClass = null;
            return null;
        }
        Class clazz = this.namespace.getClass(this.evalName);
        if (clazz == null) {
            Object object = null;
            try {
                object = this.toObject(null, null, true);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
            if (object instanceof ClassIdentifier) {
                clazz = ((ClassIdentifier)object).getTargetClass();
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class: " + this.value + " not found in namespace");
        }
        this.asClass = clazz;
        return this.asClass;
    }

    public synchronized LHS toLHS(CallStack callStack, Interpreter interpreter) throws UtilEvalError {
        this.reset();
        if (!Name.isCompound(this.evalName)) {
            LHS lHS = new LHS(this.namespace, this.evalName, false);
            return lHS;
        }
        Object object = null;
        try {
            while (this.evalName != null && Name.isCompound(this.evalName)) {
                object = this.consumeNextObjectField(callStack, interpreter, false, true);
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new UtilEvalError("LHS evaluation: " + utilEvalError);
        }
        if (object instanceof ClassIdentifier) {
            throw new UtilEvalError("Can't assign to class: " + this.value);
        }
        if (object == null) {
            throw new UtilEvalError("Error in LHS: " + this.value);
        }
        if (object instanceof This) {
            if (this.evalName.equals("namespace") || this.evalName.equals("variables") || this.evalName.equals("methods") || this.evalName.equals("caller")) {
                throw new UtilEvalError("Can't assign to special variable: " + this.evalName);
            }
            Interpreter.debug("found This reference evaluating LHS");
            boolean bl = !this.lastEvalName.equals("super");
            return new LHS(((This)object).namespace, this.evalName, bl);
        }
        if (this.evalName != null) {
            try {
                if (object instanceof ClassIdentifier) {
                    Class clazz = ((ClassIdentifier)object).getTargetClass();
                    LHS lHS = Reflect.getLHSStaticField(clazz, this.evalName);
                    return lHS;
                }
                LHS lHS = Reflect.getLHSObjectField(object, this.evalName);
                return lHS;
            }
            catch (ReflectError reflectError) {
                throw new UtilEvalError("Field access: " + reflectError);
            }
        }
        throw new InterpreterError("Internal error in lhs...");
    }

    public Object invokeMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws UtilEvalError, EvalError, ReflectError, InvocationTargetException {
        Class clazz;
        String string2 = Name.suffix(this.value, 1);
        BshClassManager bshClassManager = callStack.top().getClassManager();
        if (this.classOfStaticMethod != null) {
            return Reflect.invokeStaticMethod(bshClassManager, this.classOfStaticMethod, string2, objectArray);
        }
        if (!Name.isCompound(this.value)) {
            return this.invokeLocalMethod(interpreter, objectArray, callStack, simpleNode);
        }
        Name name = this.namespace.getNameResolver(Name.prefix(this.value));
        Object object = name.toObject(callStack, interpreter);
        if (object == Primitive.VOID) {
            throw new UtilEvalError("Attempt to resolve method: " + string2 + "() on undefined variable or class name: " + name);
        }
        if (!(object instanceof ClassIdentifier)) {
            if (object instanceof Primitive) {
                if (object == Primitive.NULL) {
                    throw new UtilTargetError(new NullPointerException("Null Pointer in Method Invocation"));
                }
                if (Interpreter.DEBUG) {
                    Interpreter.debug("Attempt to access method on primitive... allowing bsh.Primitive to peek through for debugging");
                }
            }
            return Reflect.invokeObjectMethod(object, string2, objectArray, interpreter, callStack, simpleNode);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeMethod: trying static - " + name);
        }
        this.classOfStaticMethod = clazz = ((ClassIdentifier)object).getTargetClass();
        if (clazz != null) {
            return Reflect.invokeStaticMethod(bshClassManager, clazz, string2, objectArray);
        }
        throw new UtilEvalError("invokeMethod: unknown target: " + name);
    }

    private Object invokeLocalMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        Object object;
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeLocalMethod: " + this.value);
        }
        if (interpreter == null) {
            throw new InterpreterError("invokeLocalMethod: interpreter = null");
        }
        String string2 = this.value;
        Class[] classArray = Reflect.getTypes(objectArray);
        BshMethod bshMethod = null;
        try {
            bshMethod = this.namespace.getMethod(string2, classArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Local method invocation", simpleNode, callStack);
        }
        if (bshMethod != null) {
            return bshMethod.invoke(objectArray, interpreter, callStack, simpleNode);
        }
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            object = this.namespace.getCommand(string2, classArray, interpreter);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Error loading command: ", simpleNode, callStack);
        }
        if (object == null) {
            BshMethod bshMethod2 = null;
            try {
                bshMethod2 = this.namespace.getMethod("invoke", new Class[]{null, null});
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError("Local method invocation", simpleNode, callStack);
            }
            if (bshMethod2 != null) {
                return bshMethod2.invoke(new Object[]{string2, objectArray}, interpreter, callStack, simpleNode);
            }
            throw new EvalError("Command not found: " + StringUtil.methodString(string2, classArray), simpleNode, callStack);
        }
        if (object instanceof BshMethod) {
            return ((BshMethod)object).invoke(objectArray, interpreter, callStack, simpleNode);
        }
        if (object instanceof Class) {
            try {
                return Reflect.invokeCompiledCommand((Class)object, objectArray, interpreter, callStack);
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError("Error invoking compiled command: ", simpleNode, callStack);
            }
        }
        throw new InterpreterError("invalid command type");
    }

    public static boolean isCompound(String string2) {
        return string2.indexOf(46) != -1;
    }

    static int countParts(String string2) {
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = string2.indexOf(46, n2 + 1)) != -1) {
            ++n;
        }
        return n + 1;
    }

    static String prefix(String string2) {
        if (!Name.isCompound(string2)) {
            return null;
        }
        return Name.prefix(string2, Name.countParts(string2) - 1);
    }

    static String prefix(String string2, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = string2.indexOf(46, n3 + 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string2 : string2.substring(0, n3);
    }

    static String suffix(String string2) {
        if (!Name.isCompound(string2)) {
            return null;
        }
        return Name.suffix(string2, Name.countParts(string2) - 1);
    }

    public static String suffix(String string2, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = string2.length() + 1;
        while ((n3 = string2.lastIndexOf(46, n3 - 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string2 : string2.substring(n3 + 1);
    }

    public String toString() {
        return this.value;
    }
}

