/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.FloatProcedure;
import cern.colt.list.AbstractFloatList;
import cern.colt.list.AbstractList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class FloatArrayList
extends AbstractFloatList {
    protected float[] elements;

    public FloatArrayList() {
        this(10);
    }

    public FloatArrayList(float[] fArray) {
        this.elements(fArray);
    }

    public FloatArrayList(int n) {
        this(new float[n]);
        this.setSizeRaw(0);
    }

    public void add(float f) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = f;
    }

    public void beforeInsert(int n, float f) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = f;
        ++this.size;
    }

    public int binarySearchFromTo(float f, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, f, n, n2);
    }

    public Object clone() {
        FloatArrayList floatArrayList = new FloatArrayList((float[])this.elements.clone());
        floatArrayList.setSizeRaw(this.size);
        return floatArrayList;
    }

    public FloatArrayList copy() {
        return (FloatArrayList)this.clone();
    }

    public float[] elements() {
        return this.elements;
    }

    public AbstractFloatList elements(float[] fArray) {
        this.elements = fArray;
        this.size = fArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FloatArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        FloatArrayList floatArrayList = (FloatArrayList)object;
        if (this.size() != floatArrayList.size()) {
            return false;
        }
        float[] fArray = this.elements();
        float[] fArray2 = floatArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (fArray[n] == fArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(FloatProcedure floatProcedure) {
        float[] fArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (floatProcedure.apply(fArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public float get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public float getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(float f, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        float[] fArray = this.elements;
        int n3 = n;
        while (n3 <= n2) {
            if (f == fArray[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOfFromTo(float f, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        float[] fArray = this.elements;
        int n3 = n2;
        while (n3 >= n) {
            if (f == fArray[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public AbstractFloatList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new FloatArrayList(0);
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        float[] fArray = new float[n2 - n + 1];
        System.arraycopy(this.elements, n, fArray, 0, n2 - n + 1);
        return new FloatArrayList(fArray);
    }

    public boolean removeAll(AbstractFloatList abstractFloatList) {
        double d;
        if (!(abstractFloatList instanceof FloatArrayList)) {
            return super.removeAll(abstractFloatList);
        }
        if (abstractFloatList.size() == 0) {
            return false;
        }
        int n = abstractFloatList.size() - 1;
        int n2 = 0;
        float[] fArray = this.elements;
        int n3 = this.size();
        double d2 = abstractFloatList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            FloatArrayList floatArrayList = (FloatArrayList)abstractFloatList.clone();
            floatArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (floatArrayList.binarySearchFromTo(fArray[n4], 0, n) < 0) {
                    fArray[n2++] = fArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractFloatList.indexOfFromTo(fArray[n5], 0, n) < 0) {
                    fArray[n2++] = fArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractFloatList abstractFloatList, int n3) {
        if (!(abstractFloatList instanceof FloatArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractFloatList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractFloatList.size());
            System.arraycopy(((FloatArrayList)abstractFloatList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractFloatList abstractFloatList) {
        double d;
        if (!(abstractFloatList instanceof FloatArrayList)) {
            return super.retainAll(abstractFloatList);
        }
        int n = abstractFloatList.size() - 1;
        int n2 = 0;
        float[] fArray = this.elements;
        int n3 = this.size();
        double d2 = abstractFloatList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            FloatArrayList floatArrayList = (FloatArrayList)abstractFloatList.clone();
            floatArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (floatArrayList.binarySearchFromTo(fArray[n4], 0, n) >= 0) {
                    fArray[n2++] = fArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractFloatList.indexOfFromTo(fArray[n5], 0, n) >= 0) {
                    fArray[n2++] = fArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        float[] fArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            float f = fArray[n3];
            fArray[n3++] = fArray[n2];
            fArray[n2--] = f;
        }
    }

    public void set(int n, float f) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = f;
    }

    public void setQuick(int n, float f) {
        this.elements[n] = f;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        float[] fArray = this.elements;
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            float f = fArray[n4];
            fArray[n4] = fArray[n3];
            fArray[n3] = f;
            ++n3;
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

