/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.objectalgo;

import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.ObjectMatrix3D;
import cern.colt.matrix.impl.AbstractFormatter;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.Former;

public class Formatter
extends AbstractFormatter {
    public Formatter() {
        this("left");
    }

    public Formatter(String string2) {
        this.setAlignment(string2);
    }

    protected String form(AbstractMatrix1D abstractMatrix1D, int n, Former former) {
        return this.form((ObjectMatrix1D)abstractMatrix1D, n, former);
    }

    protected String form(ObjectMatrix1D objectMatrix1D, int n, Former former) {
        Object object = objectMatrix1D.get(n);
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    protected String[][] format(AbstractMatrix2D abstractMatrix2D) {
        return this.format((ObjectMatrix2D)abstractMatrix2D);
    }

    protected String[][] format(ObjectMatrix2D objectMatrix2D) {
        String[][] stringArray = new String[objectMatrix2D.rows()][objectMatrix2D.columns()];
        int n = objectMatrix2D.rows();
        while (--n >= 0) {
            stringArray[n] = this.formatRow(objectMatrix2D.viewRow(n));
        }
        return stringArray;
    }

    public String toSourceCode(ObjectMatrix1D objectMatrix1D) {
        Formatter formatter = (Formatter)this.clone();
        formatter.setPrintShape(false);
        formatter.setColumnSeparator(", ");
        String string2 = "{";
        String string3 = "};";
        return string2 + formatter.toString(objectMatrix1D) + string3;
    }

    public String toSourceCode(ObjectMatrix2D objectMatrix2D) {
        Formatter formatter = (Formatter)this.clone();
        String string2 = this.blanks(3);
        formatter.setPrintShape(false);
        formatter.setColumnSeparator(", ");
        formatter.setRowSeparator("},\n" + string2 + "{");
        String string3 = "{\n" + string2 + "{";
        String string4 = "}\n};";
        return string3 + formatter.toString(objectMatrix2D) + string4;
    }

    public String toSourceCode(ObjectMatrix3D objectMatrix3D) {
        Formatter formatter = (Formatter)this.clone();
        String string2 = this.blanks(3);
        String string3 = this.blanks(6);
        formatter.setPrintShape(false);
        formatter.setColumnSeparator(", ");
        formatter.setRowSeparator("},\n" + string3 + "{");
        formatter.setSliceSeparator("}\n" + string2 + "},\n" + string2 + "{\n" + string3 + "{");
        String string4 = "{\n" + string2 + "{\n" + string3 + "{";
        String string5 = "}\n" + string2 + "}\n}";
        return string4 + formatter.toString(objectMatrix3D) + string5;
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        return this.toString((ObjectMatrix2D)abstractMatrix2D);
    }

    public String toString(ObjectMatrix1D objectMatrix1D) {
        ObjectMatrix2D objectMatrix2D = objectMatrix1D.like2D(1, objectMatrix1D.size());
        objectMatrix2D.viewRow(0).assign(objectMatrix1D);
        return this.toString(objectMatrix2D);
    }

    public String toString(ObjectMatrix2D objectMatrix2D) {
        return super.toString(objectMatrix2D);
    }

    public String toString(ObjectMatrix3D objectMatrix3D) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.printShape;
        this.printShape = false;
        int n = 0;
        while (n < objectMatrix3D.slices()) {
            if (n != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toString(objectMatrix3D.viewSlice(n)));
            ++n;
        }
        this.printShape = bl;
        if (this.printShape) {
            stringBuffer.insert(0, AbstractFormatter.shape(objectMatrix3D) + "\n");
        }
        return stringBuffer.toString();
    }

    public String toTitleString(ObjectMatrix2D objectMatrix2D, String[] stringArray, String[] stringArray2, String string2, String string3, String string4) {
        int n;
        if (objectMatrix2D.size() == 0) {
            return "Empty matrix";
        }
        String string5 = this.format;
        this.format = "left";
        int n2 = objectMatrix2D.rows();
        int n3 = objectMatrix2D.columns();
        int n4 = 0;
        int n5 = 0;
        n5 += stringArray == null ? 0 : 1;
        n5 += string2 == null ? 0 : 1;
        int n6 = (n4 += stringArray2 == null ? 0 : 1) + Math.max(n2, string2 == null ? 0 : string2.length());
        int n7 = (n5 += stringArray != null || string2 != null ? 1 : 0) + n3;
        ObjectMatrix2D objectMatrix2D2 = objectMatrix2D.like(n6, n7);
        objectMatrix2D2.viewPart(n4, n5, n2, n3).assign(objectMatrix2D);
        if (n4 > 0) {
            objectMatrix2D2.viewRow(0).viewPart(n5, n3).assign(stringArray2);
        }
        if (string2 != null) {
            Object[] objectArray = new String[string2.length()];
            int n8 = string2.length();
            while (--n8 >= 0) {
                objectArray[n8] = string2.substring(n8, n8 + 1);
            }
            objectMatrix2D2.viewColumn(0).viewPart(n4, string2.length()).assign(objectArray);
        }
        if (stringArray != null) {
            objectMatrix2D2.viewColumn(n5 - 2).viewPart(n4, n2).assign(stringArray);
        }
        if (n5 > 0) {
            objectMatrix2D2.viewColumn(n5 - 2 + 1).viewPart(0, n2 + n4).assign("|");
        }
        boolean bl = this.printShape;
        this.printShape = false;
        String string6 = this.toString(objectMatrix2D2);
        this.printShape = bl;
        StringBuffer stringBuffer = new StringBuffer(string6);
        if (stringArray2 != null) {
            n = string6.indexOf(this.rowSeparator);
            stringBuffer.insert(n + 1, this.repeat('-', n) + this.rowSeparator);
        } else if (string3 != null) {
            n = string6.indexOf(this.rowSeparator);
            stringBuffer.insert(0, this.repeat('-', n) + this.rowSeparator);
        }
        if (string3 != null) {
            n = 0;
            if (n5 > 0) {
                n = string6.indexOf(124);
            }
            String string7 = this.blanks(n);
            if (n5 > 0) {
                string7 = string7 + "| ";
            }
            string7 = string7 + string3 + "\n";
            stringBuffer.insert(0, string7);
        }
        if (string4 != null) {
            stringBuffer.insert(0, string4 + "\n");
        }
        this.format = string5;
        return stringBuffer.toString();
    }

    public String toTitleString(ObjectMatrix3D objectMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string2, String string3, String string4, String string5) {
        if (objectMatrix3D.size() == 0) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectMatrix3D.slices()) {
            if (n != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(objectMatrix3D.viewSlice(n), stringArray2, stringArray3, string3, string4, string5 + "\n" + string2 + "=" + stringArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }
}

