/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Empirical
extends AbstractContinousDistribution {
    protected double[] cdf;
    protected int interpolationType;
    public static final int LINEAR_INTERPOLATION = 0;
    public static final int NO_INTERPOLATION = 1;

    public Empirical(double[] dArray, int n, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(dArray, n);
    }

    public double cdf(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.cdf.length - 1) {
            return 1.0;
        }
        return this.cdf[n];
    }

    public Object clone() {
        Empirical empirical = (Empirical)super.clone();
        if (this.cdf != null) {
            empirical.cdf = (double[])this.cdf.clone();
        }
        return empirical;
    }

    public double nextDouble() {
        double d = this.randomGenerator.raw();
        if (this.cdf == null) {
            return d;
        }
        int n = this.cdf.length - 1;
        int n2 = 0;
        int n3 = n;
        while (n3 > n2 + 1) {
            int n4 = n3 + n2 + 1 >> 1;
            if (d >= this.cdf[n4]) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (this.interpolationType == 1) {
            return (double)n2 / (double)n;
        }
        if (this.interpolationType == 0) {
            double d2 = this.cdf[n3] - this.cdf[n2];
            if (d2 == 0.0) {
                return ((double)n2 + 0.5) / (double)n;
            }
            double d3 = (d - this.cdf[n2]) / d2;
            return ((double)n2 + d3) / (double)n;
        }
        throw new InternalError();
    }

    public double pdf(double d) {
        throw new RuntimeException("not implemented");
    }

    public double pdf(int n) {
        if (n < 0 || n >= this.cdf.length - 1) {
            return 0.0;
        }
        return this.cdf[n - 1] - this.cdf[n];
    }

    public void setState(double[] dArray, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal Interpolation Type");
        }
        this.interpolationType = n;
        if (dArray == null || dArray.length == 0) {
            this.cdf = null;
            return;
        }
        int n2 = dArray.length;
        this.cdf = new double[n2 + 1];
        this.cdf[0] = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d = dArray[n3];
            if (d < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[n3 + 1] = this.cdf[n3] + d;
            ++n3;
        }
        if (this.cdf[n2] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        int n4 = 0;
        while (n4 < n2 + 1) {
            int n5 = n4++;
            this.cdf[n5] = this.cdf[n5] / this.cdf[n2];
        }
    }

    public String toString() {
        String string2 = null;
        if (this.interpolationType == 1) {
            string2 = "NO_INTERPOLATION";
        }
        if (this.interpolationType == 0) {
            string2 = "LINEAR_INTERPOLATION";
        }
        return this.getClass().getName() + "(" + (this.cdf != null ? this.cdf.length : 0) + "," + string2 + ")";
    }

    private int xnBins() {
        return this.cdf.length - 1;
    }
}

