/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.ArrayVect1;
import com.lgc.wsh.inv.Quadratic;
import com.lgc.wsh.inv.QuadraticSolver;
import com.lgc.wsh.inv.Vect;
import com.lgc.wsh.util.Almost;
import java.util.Arrays;
import java.util.logging.Logger;

public class CoordinateTransform {
    private static final Logger LOG;
    private int _nout = 0;
    private int _nin = 0;
    private double[][] _hessian;
    private double[][] _b;
    private double[][] _a;
    private double[] _in0 = null;
    private double[] _out0 = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CoordinateTransform(int dimensionOut, int dimensionIn) {
        this._nout = dimensionOut;
        this._nin = dimensionIn;
        this._hessian = new double[this._nin][this._nin];
        this._b = new double[this._nout][this._nin];
    }

    public synchronized void add(double[] out, double[] in) {
        int i;
        this._a = null;
        if (in.length != this._nin) {
            throw new IllegalArgumentException("in must have dimension " + this._nin);
        }
        if (out.length != this._nout) {
            throw new IllegalArgumentException("out must have dimension " + this._nout);
        }
        if (this._in0 == null) {
            this._in0 = (double[])in.clone();
        }
        if (this._out0 == null) {
            this._out0 = (double[])out.clone();
        }
        in = (double[])in.clone();
        for (i = 0; i < in.length; ++i) {
            in[i] = in[i] - this._in0[i];
        }
        out = (double[])out.clone();
        for (i = 0; i < out.length; ++i) {
            out[i] = out[i] - this._out0[i];
        }
        for (int k = 0; k < this._nin; ++k) {
            for (int i2 = 0; i2 < this._nin; ++i2) {
                double[] dArray = this._hessian[k];
                int n = i2;
                dArray[n] = dArray[n] + in[k] * in[i2];
            }
            for (int o = 0; o < this._nout; ++o) {
                double[] dArray = this._b[o];
                int n = k;
                dArray[n] = dArray[n] - out[o] * in[k];
            }
        }
    }

    public synchronized double[] get(double[] in) {
        in = (double[])in.clone();
        for (int i = 0; i < in.length; ++i) {
            in[i] = in[i] - this._in0[i];
        }
        if (this._a == null) {
            this._a = new double[this._nout][this._nin];
            for (int o = 0; o < this._nout; ++o) {
                LinearQuadratic lq = new LinearQuadratic(o);
                QuadraticSolver qs = new QuadraticSolver(lq);
                ArrayVect1 solution = (ArrayVect1)qs.solve(this._nin + 4, null);
                double[] data = solution.getData();
                for (int i = 0; i < this._nin; ++i) {
                    this._a[o][i] = data[i];
                }
                solution.dispose();
            }
        }
        double[] result = new double[this._nout];
        for (int o = 0; o < this._nout; ++o) {
            for (int i = 0; i < this._nin; ++i) {
                int n = o;
                result[n] = result[n] + this._a[o][i] * in[i];
            }
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i] + this._out0[i];
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        double[][] in = new double[][]{{1.0, 1.0}, {2.0, 2.0}, {3.0, 4.0}};
        double[][] out = new double[][]{{2.0}, {4.0}, {7.0}};
        CoordinateTransform ls = new CoordinateTransform(1, 2);
        for (int j = 0; j < out.length; ++j) {
            ls.add(out[j], in[j]);
        }
        Almost almost = new Almost();
        double a = 1.0;
        double b = 1.0;
        if (!$assertionsDisabled && !almost.equal(a + b, ls.get(new double[]{a, b})[0])) {
            throw new AssertionError((Object)(a + "+" + b + "!=" + ls.get(new double[]{a, b})[0]));
        }
        a = 2.0;
        b = 2.0;
        if (!$assertionsDisabled && !almost.equal(a + b, ls.get(new double[]{a, b})[0])) {
            throw new AssertionError((Object)(a + "+" + b + "!=" + ls.get(new double[]{a, b})[0]));
        }
        a = 3.0;
        b = 4.0;
        if (!$assertionsDisabled && !almost.equal(a + b, ls.get(new double[]{a, b})[0])) {
            throw new AssertionError((Object)(a + "+" + b + "!=" + ls.get(new double[]{a, b})[0]));
        }
        a = 1.0;
        b = 3.0;
        if (!$assertionsDisabled && !almost.equal(a + b, ls.get(new double[]{a, b})[0])) {
            throw new AssertionError((Object)(a + "+" + b + "!=" + ls.get(new double[]{a, b})[0]));
        }
        a = 3.0;
        b = 7.0;
        if (!$assertionsDisabled && !almost.equal(a + b, ls.get(new double[]{a, b})[0])) {
            throw new AssertionError((Object)(a + "+" + b + "!=" + ls.get(new double[]{a, b})[0]));
        }
    }

    static {
        $assertionsDisabled = !CoordinateTransform.class.desiredAssertionStatus();
        LOG = Logger.getLogger("com.lgc.wsh.inv");
    }

    private class LinearQuadratic
    implements Quadratic {
        int _o = -1;

        public LinearQuadratic(int o) {
            this._o = o;
        }

        public void multiplyHessian(Vect x) {
            ArrayVect1 m = (ArrayVect1)x;
            double[] data = m.getData();
            double[] oldData = (double[])data.clone();
            Arrays.fill(data, 0.0);
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data.length; ++j) {
                    int n = i;
                    data[n] = data[n] + CoordinateTransform.this._hessian[i][j] * oldData[j];
                }
            }
        }

        public Vect getB() {
            return new ArrayVect1((double[])CoordinateTransform.this._b[this._o].clone(), 1.0);
        }

        public void inverseHessian(Vect x) {
        }
    }
}

