/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.ArrayVect1;
import com.lgc.wsh.inv.LogMonitor;
import com.lgc.wsh.inv.Monitor;
import com.lgc.wsh.inv.Quadratic;
import com.lgc.wsh.inv.Vect;
import com.lgc.wsh.inv.VectUtil;
import com.lgc.wsh.util.Almost;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class QuadraticSolver {
    private Quadratic _quadratic = null;
    private static final Logger LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuadraticSolver(Quadratic quadratic) {
        this._quadratic = quadratic;
    }

    public Vect solve(int numberIterations, Monitor monitor) {
        if (monitor == null) {
            monitor = new LogMonitor(null, null);
        }
        monitor.report(0.0);
        Vect b = this._quadratic.getB();
        monitor.report(1.0 / ((double)numberIterations + 2.0));
        double bb = b.dot(b);
        QuadraticSolver.checkNaN(bb);
        if (Almost.FLOAT.zero(bb)) {
            LOG.fine("Gradient of quadratic is negligible.  Not solving");
            Vect result = VectUtil.cloneZero(b);
            monitor.report(1.0);
            return result;
        }
        Vect g = b;
        b = null;
        Vect x = VectUtil.cloneZero(g);
        Vect p = (Vect)x.clone();
        Vect u = (Vect)x.clone();
        double pu = 0.0;
        for (int iter = 0; iter < numberIterations; ++iter) {
            double beta = 0.0;
            Vect q = (Vect)g.clone();
            this._quadratic.inverseHessian(q);
            q.postCondition();
            this._quadratic.multiplyHessian(q);
            monitor.report(((double)iter + 2.0) / ((double)numberIterations + 2.0));
            if (iter > 0) {
                double pq = p.dot(q);
                QuadraticSolver.checkNaN(pq);
                beta = Almost.FLOAT.divide(pq, pu, 0.0);
                if (beta < -5.0) {
                    beta = -5.0;
                }
                if (beta > 5.0) {
                    beta = 5.0;
                }
            }
            u.add(beta, -1.0, q);
            q.dispose();
            Vect a = (Vect)g.clone();
            this._quadratic.inverseHessian(a);
            a.postCondition();
            p.add(beta, -1.0, a);
            a.dispose();
            double pg = p.dot(g);
            QuadraticSolver.checkNaN(pg);
            pu = p.dot(u);
            QuadraticSolver.checkNaN(pu);
            if (Almost.FLOAT.zero(pg) || Almost.FLOAT.zero(pu)) break;
            double scalar = -pg / pu;
            x.add(1.0, scalar, p);
            if (iter == numberIterations - 1) break;
            g.add(1.0, scalar, u);
        }
        p.dispose();
        u.dispose();
        g.dispose();
        monitor.report(1.0);
        return x;
    }

    private static void checkNaN(double value) {
        if (value * 0.0 != 0.0) {
            throw new IllegalStateException("Value is a NaN");
        }
    }

    public static void main(String[] args) throws Exception {
        Quadratic q = new Quadratic(){

            public void multiplyHessian(Vect x) {
                double[] data = ((ArrayVect1)x).getData();
                double[] newData = new double[data.length];
                newData[0] = 2.0 * data[0] + 4.0 * data[1];
                newData[1] = 4.0 * data[0] + 11.0 * data[1];
                data[0] = newData[0];
                data[1] = newData[1];
            }

            public void inverseHessian(Vect x) {
            }

            public Vect getB() {
                return new TestVect(new double[]{2.0, 1.0}, 1.0);
            }
        };
        QuadraticSolver qs = new QuadraticSolver(q);
        ArrayVect1 result = (ArrayVect1)qs.solve(1, null);
        if (!$assertionsDisabled && Almost.FLOAT.equal(-3.0, result.getData()[0])) {
            throw new AssertionError((Object)("result=" + result));
        }
        if (!$assertionsDisabled && Almost.FLOAT.equal(1.0, result.getData()[1])) {
            throw new AssertionError((Object)("result=" + result));
        }
        result.dispose();
        result = (ArrayVect1)qs.solve(2, null);
        if (!$assertionsDisabled && !Almost.FLOAT.equal(-3.0, result.getData()[0])) {
            throw new AssertionError((Object)("result=" + result));
        }
        if (!$assertionsDisabled && !Almost.FLOAT.equal(1.0, result.getData()[1])) {
            throw new AssertionError((Object)("result=" + result));
        }
        result.dispose();
        result = (ArrayVect1)qs.solve(20, null);
        if (!$assertionsDisabled && !Almost.FLOAT.equal(-3.0, result.getData()[0])) {
            throw new AssertionError((Object)("result=" + result));
        }
        if (!$assertionsDisabled && !Almost.FLOAT.equal(1.0, result.getData()[1])) {
            throw new AssertionError((Object)("result=" + result));
        }
        result.dispose();
        if (!$assertionsDisabled && TestVect.undisposed.size() != 0) {
            throw new AssertionError((Object)TestVect.getTraces());
        }
        if (!$assertionsDisabled && TestVect.max > 5) {
            throw new AssertionError((Object)("max number of model vectors (" + TestVect.max + ") should be less than 5"));
        }
    }

    static {
        $assertionsDisabled = !QuadraticSolver.class.desiredAssertionStatus();
        LOG = Logger.getLogger("com.lgc.wsh.inv");
    }

    private static class TestVect
    extends ArrayVect1 {
        public static int max = 0;
        public static Map undisposed = Collections.synchronizedMap(new HashMap());

        public TestVect(double[] data, double variance) {
            super(data, variance);
            this.remember(this);
        }

        public Object clone() {
            Object result = super.clone();
            this.remember(result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remember(Object tv) {
            Map map = undisposed;
            synchronized (map) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                new Exception("This vector was never disposed").printStackTrace(pw);
                pw.flush();
                undisposed.put(tv, sw.toString());
                max = Math.max(max, undisposed.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Map map = undisposed;
            synchronized (map) {
                super.dispose();
                undisposed.remove(this);
            }
        }

        public static String getTraces() {
            StringBuffer sb = new StringBuffer();
            Iterator iterator = undisposed.values().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                sb.append((String)iterator.next());
                sb.append("\n");
                ++i;
            }
            return sb.toString();
        }
    }
}

