/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerStream
extends PrintStream {
    private Level _level = null;
    private Logger _logger = null;
    private ByteArrayOutputStream _baos = (ByteArrayOutputStream)this.out;

    public LoggerStream(Logger logger, Level level) {
        super(new ByteArrayOutputStream(), true);
        this._logger = logger;
        this._level = level;
    }

    public synchronized void flush() {
        super.flush();
        if (this._baos.size() == 0) {
            return;
        }
        String out = this._baos.toString();
        this.logit(out);
        this._baos.reset();
    }

    public synchronized void println() {
        this.flush();
    }

    public synchronized void println(Object x) {
        super.print(x);
        this.flush();
    }

    public synchronized void println(String x) {
        super.print(x);
        this.flush();
    }

    public synchronized void close() {
        this.flush();
        super.close();
    }

    public synchronized boolean checkError() {
        this.flush();
        return super.checkError();
    }

    private synchronized void logit(String s) {
        if (Level.CONFIG.equals(this._level)) {
            this._logger.config(s);
        } else if (Level.FINE.equals(this._level)) {
            this._logger.fine(s);
        } else if (Level.FINER.equals(this._level)) {
            this._logger.finer(s);
        } else if (Level.FINEST.equals(this._level)) {
            this._logger.finest(s);
        } else if (Level.INFO.equals(this._level)) {
            this._logger.info(s);
        } else if (Level.SEVERE.equals(this._level)) {
            this._logger.severe(s);
        } else if (Level.WARNING.equals(this._level)) {
            this._logger.warning(s);
        } else {
            throw new IllegalArgumentException("You constructed a LoggerStream with an invalid Level " + this._level);
        }
    }

    public static void main(String[] args) {
        Logger logger = Logger.getLogger("com.lgc.wsh.util");
        LoggerStream psInfo = new LoggerStream(logger, Level.INFO);
        LoggerStream psWarning = new LoggerStream(logger, Level.WARNING);
        psInfo.print(3.0);
        ((PrintStream)psInfo).println("*3.=9.");
        psWarning.print(3.0);
        ((PrintStream)psWarning).println("*3.=9.");
        psInfo.print(3.0);
        ((PrintStream)psInfo).flush();
        ((PrintStream)psInfo).println("*3.=9.");
        ((PrintStream)psInfo).println();
        psInfo.print("x");
        ((PrintStream)psInfo).close();
    }
}

