/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.AbstractInstance;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.multi.MultiExample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class FeatureFactory
implements Serializable {
    private static final long serialVersionUID = 20080115L;
    private HashMap<Feature, Feature> canonicalMap = new HashMap();
    private HashMap<Feature, Integer> featureIdMap = new HashMap();
    private List<Feature> idFeatureMap = new ArrayList<Feature>();

    public int getMaxFeatureIndex() {
        return this.idFeatureMap.size() - 1;
    }

    public boolean contains(Feature f) {
        return this.canonicalMap.containsKey(f);
    }

    public Feature getFeature(Feature f) {
        Feature canonical = this.canonicalMap.get(f);
        if (canonical == null) {
            canonical = new Feature(f.getName(), this.idFeatureMap.size());
            this.canonicalMap.put(f, canonical);
            this.featureIdMap.put(canonical, this.idFeatureMap.size());
            this.idFeatureMap.add(canonical);
        }
        return canonical;
    }

    public Feature getFeature(String fullName) {
        Feature f = new Feature(fullName);
        return this.getFeature(f);
    }

    public Feature getFeature(String[] name) {
        Feature f = new Feature(name);
        return this.getFeature(f);
    }

    public Feature getFeature(int id) {
        if (id < 0 || id >= this.idFeatureMap.size()) {
            return null;
        }
        return this.idFeatureMap.get(id);
    }

    public int getID(Feature feature) {
        return this.featureIdMap.get(feature);
    }

    public CompactInstance compress(Instance instance) {
        if (instance instanceof CompactInstance && ((CompactInstance)instance).getFactory() == this) {
            return (CompactInstance)instance;
        }
        return new CompactInstance(instance);
    }

    public Example compress(Example example) {
        return new Example(this.compress(example.asInstance()), example.getLabel(), example.getWeight());
    }

    public MultiExample compress(MultiExample example) {
        return new MultiExample((Instance)this.compress(example.asInstance()), example.getMultiLabel(), example.getWeight());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(super.toString()).append(" : [");
        for (int i = 0; i < this.idFeatureMap.size(); ++i) {
            b.append(i).append("=").append(this.idFeatureMap.get(i));
            if (i >= this.idFeatureMap.size() - 1) continue;
            b.append(" ");
        }
        b.append("]");
        return b.toString();
    }

    private static Feature[] combine(Feature[] a1, Feature[] a2) {
        int i;
        Feature[] combined = new Feature[a1.length + a2.length];
        for (i = 0; i < a1.length; ++i) {
            combined[i] = a1[i];
        }
        for (i = 0; i < a2.length; ++i) {
            combined[a1.length + i] = a2[i];
        }
        return combined;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompactInstance
    extends AbstractInstance
    implements Serializable {
        static final long serialVersionUID = 20071015L;
        private Feature[] binaryFeatures;
        private Feature[] numericFeatures;
        private double[] weights;

        public CompactInstance(Instance instance) {
            this.source = instance.getSource();
            this.subpopulationId = instance.getSubpopulationId();
            TreeSet<Feature> set = new TreeSet<Feature>();
            Iterator<Feature> it = instance.binaryFeatureIterator();
            while (it.hasNext()) {
                set.add(FeatureFactory.this.getFeature(it.next()));
            }
            this.binaryFeatures = set.toArray(new Feature[set.size()]);
            set.clear();
            it = instance.numericFeatureIterator();
            while (it.hasNext()) {
                set.add(FeatureFactory.this.getFeature(it.next()));
            }
            this.numericFeatures = set.toArray(new Feature[set.size()]);
            this.weights = new double[this.numericFeatures.length];
            for (int i = 0; i < this.numericFeatures.length; ++i) {
                this.weights[i] = instance.getWeight(this.numericFeatures[i]);
            }
        }

        public FeatureFactory getFactory() {
            return FeatureFactory.this;
        }

        @Override
        public double getWeight(Feature f) {
            if (Arrays.binarySearch(this.binaryFeatures, f) > -1) {
                return 1.0;
            }
            int index = Arrays.binarySearch(this.numericFeatures, f);
            if (index > -1) {
                return this.weights[index];
            }
            return 0.0;
        }

        @Override
        public Iterator<Feature> binaryFeatureIterator() {
            return new FeatureArrayIterator(this.binaryFeatures);
        }

        @Override
        public Iterator<Feature> numericFeatureIterator() {
            return new FeatureArrayIterator(this.numericFeatures);
        }

        @Override
        public Iterator<Feature> featureIterator() {
            return new UnionFeatureArrayIterator(this.binaryFeatures, this.numericFeatures);
        }

        @Override
        public int numFeatures() {
            return this.binaryFeatures.length + this.numericFeatures.length;
        }

        @Override
        public String toString() {
            int i;
            StringBuilder b = new StringBuilder();
            b.append("[compact instance/").append(this.subpopulationId).append(":");
            for (i = 0; i < this.binaryFeatures.length; ++i) {
                b.append(" ").append(this.binaryFeatures[i]);
            }
            for (i = 0; i < this.numericFeatures.length; ++i) {
                b.append(" ").append(this.numericFeatures[i]).append(":").append(this.getWeight(this.numericFeatures[i]));
            }
            b.append("]");
            return b.toString();
        }

        public class UnionFeatureArrayIterator
        extends FeatureArrayIterator {
            public UnionFeatureArrayIterator(Feature[] features, Feature[] moreFeatures) {
                super(FeatureFactory.combine(features, moreFeatures));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class FeatureArrayIterator
        implements Iterator<Feature> {
            private int current = 0;
            private Feature[] features;

            public FeatureArrayIterator(Feature[] features) {
                this.features = features;
            }

            @Override
            public boolean hasNext() {
                return this.current < this.features.length;
            }

            @Override
            public Feature next() {
                return this.features[this.current++];
            }

            @Override
            public void remove() {
                throw new Error("method CompactInstance.FeatureArrayLooper: remove not implemented.");
            }
        }
    }
}

