/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.BatchClassifierLearner;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.VotedPerceptron;
import edu.cmu.minorthird.classify.algorithms.svm.SVMLearner;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import org.apache.log4j.Logger;

public class OnlineVersion
extends OnlineClassifierLearner {
    private static Logger log = Logger.getLogger(OnlineVersion.class);
    private BatchClassifierLearner innerLearner;
    private OnlineClassifierLearner bootstrapLearner;
    private double loadFactor;
    private int minBatchTrainingSize;
    private Classifier storedClassifier;
    private int lastTrainingSetSize;
    private Dataset dataset;

    public OnlineVersion(BatchClassifierLearner innerLearner, double loadFactor, OnlineClassifierLearner bootstrapLearner, int minBatchTrainingSize) {
        this.innerLearner = innerLearner;
        this.loadFactor = loadFactor;
        this.bootstrapLearner = bootstrapLearner;
        this.minBatchTrainingSize = minBatchTrainingSize;
        this.reset();
    }

    public OnlineVersion(BatchClassifierLearner innerLearner, double loadFactor) {
        this(innerLearner, loadFactor, new VotedPerceptron(), 10);
    }

    public OnlineVersion(BatchClassifierLearner innerLearner) {
        this(innerLearner, 1.5);
    }

    public OnlineVersion() {
        this(new SVMLearner());
    }

    public BatchClassifierLearner getInnerLearner() {
        return this.innerLearner;
    }

    public void setInnerLearner(BatchClassifierLearner learner) {
        this.innerLearner = learner;
    }

    public OnlineClassifierLearner getBootstrapLearner() {
        return this.bootstrapLearner;
    }

    public void setBootstrapLearner(OnlineClassifierLearner learner) {
        this.bootstrapLearner = learner;
    }

    public double getBatchLoadFactor() {
        return this.loadFactor;
    }

    public void setBatchLoadFactor(double d) {
        this.loadFactor = d;
    }

    public int getMinBatchTrainingSize() {
        return this.minBatchTrainingSize;
    }

    public void setMinBatchTrainingSize(int m) {
        this.minBatchTrainingSize = m;
    }

    public final void setSchema(ExampleSchema schema) {
        this.innerLearner.setSchema(schema);
        this.bootstrapLearner.setSchema(schema);
    }

    public final ExampleSchema getSchema() {
        return this.innerLearner.getSchema();
    }

    public final void reset() {
        this.storedClassifier = null;
        this.lastTrainingSetSize = 0;
        this.dataset = new BasicDataset();
        this.innerLearner.reset();
        this.bootstrapLearner.reset();
    }

    public final void addExample(Example example) {
        this.dataset.add(example);
        if (this.dataset.size() < this.minBatchTrainingSize) {
            this.bootstrapLearner.addExample(example);
        }
    }

    public final void completeTraining() {
        new ViewerFrame("compete data", this.dataset.toGUI());
        if (this.dataset.size() > this.lastTrainingSetSize || this.storedClassifier == null) {
            log.info("final training for " + this.innerLearner + " on " + this.dataset.size() + " examples");
            this.storedClassifier = this.innerLearner.batchTrain(this.dataset);
            new ViewerFrame("classifier", new SmartVanillaViewer(this.storedClassifier));
            this.lastTrainingSetSize = this.dataset.size();
        }
    }

    public final Classifier getClassifier() {
        if (this.dataset.size() < this.minBatchTrainingSize) {
            return this.bootstrapLearner.getClassifier();
        }
        if ((double)this.dataset.size() > (double)this.lastTrainingSetSize * this.loadFactor || this.storedClassifier == null) {
            log.info("re-training " + this.innerLearner + " on " + this.dataset.size() + " examples");
            this.storedClassifier = this.innerLearner.batchTrain(this.dataset);
            log.info("batch classifier is " + this.storedClassifier);
            this.lastTrainingSetSize = this.dataset.size();
            return this.storedClassifier;
        }
        return this.storedClassifier;
    }
}

