/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedSet<T>
implements Serializable {
    private static final long serialVersionUID = 20080116L;
    private Map<T, Double> map = new TreeMap<T, Double>();

    public boolean add(T object, double weight) {
        boolean result = this.map.get(object) != null;
        this.map.put(object, weight);
        return result;
    }

    public double getWeight(T object, double defaultWeight) {
        Double d = this.map.get(object);
        return d == null ? defaultWeight : d;
    }

    public double getWeight(T object) {
        return this.getWeight(object, 0.0);
    }

    public Set<T> asSet() {
        return this.map.keySet();
    }

    public boolean contains(T object) {
        return this.map.get(object) != null;
    }

    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

