/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.active;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.BatchClassifierLearner;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.RandomAccessDataset;
import java.util.Random;
import org.apache.log4j.Logger;

public class CommitteeLearner {
    private static Logger log = Logger.getLogger(CommitteeLearner.class);
    private BatchClassifierLearner learner;
    private int committeeSize;

    public CommitteeLearner(BatchClassifierLearner learner, int committeeSize) {
        this.learner = learner;
        this.committeeSize = committeeSize;
    }

    public Classifier[] batchTrainCommittee(RandomAccessDataset data) {
        Classifier[] committee = new Classifier[this.committeeSize];
        Random rand = new Random(0L);
        for (int i = 0; i < committee.length; ++i) {
            Dataset ithBag = this.bag(rand, data);
            log.info("training committee member on " + ithBag.size() + " examples");
            committee[i] = this.learner.batchTrain(ithBag);
            log.info("committee member #" + i + ":\n" + committee[i]);
        }
        return committee;
    }

    private Dataset bag(Random r, RandomAccessDataset data) {
        BasicDataset result = new BasicDataset();
        for (int i = 0; i < data.size(); ++i) {
            int k = (int)(r.nextDouble() * (double)data.size());
            log.debug("bag: add example #" + k + ": " + data.getExample(k));
            result.add(data.getExample(k));
        }
        return result;
    }
}

