/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.knn;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.DatasetIndex;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.knn.KnnClassifier;
import java.io.Serializable;

public class KnnLearner
extends OnlineClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080128L;
    private DatasetIndex index;
    private ExampleSchema schema;
    private int k = 5;

    public KnnLearner() {
        this(5);
    }

    public KnnLearner(int k) {
        this.k = k;
        this.reset();
    }

    public ClassifierLearner copy() {
        KnnLearner knn = null;
        try {
            knn = (KnnLearner)this.clone();
            knn.index = new DatasetIndex();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return knn;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void reset() {
        this.index = new DatasetIndex();
    }

    public void addExample(Example e) {
        this.index.addExample(e);
    }

    public Classifier getClassifier() {
        return new KnnClassifier(this.index, this.schema, this.k);
    }

    public void setSchema(ExampleSchema schema) {
        this.schema = schema;
    }

    public ExampleSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        return "[KnnLearner k:" + this.k + "]";
    }
}

