/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;

public class MarginPerceptron
extends OnlineBinaryClassifierLearner {
    private Hyperplane s_t;
    private Hyperplane w_t;
    private double minMargin = 1.0;
    private boolean voteBeforeTrainingComplete;
    private boolean voteAfterTrainingComplete;
    private boolean trainingComplete;
    private double numExamples;
    int numExamplesAdded;

    public MarginPerceptron() {
        this(1.0, false, false);
    }

    public MarginPerceptron(double minMargin, boolean voteBeforeTrainingComplete, boolean voteAfterTrainingComplete) {
        this.minMargin = minMargin;
        this.voteBeforeTrainingComplete = voteBeforeTrainingComplete;
        this.voteAfterTrainingComplete = voteAfterTrainingComplete;
        this.reset();
    }

    public void reset() {
        this.s_t = new Hyperplane();
        this.w_t = new Hyperplane();
        this.trainingComplete = false;
        this.numExamples = 0.0;
    }

    public void addExample(Example example) {
        this.numExamples += 1.0;
        double y_t = example.getLabel().numericLabel();
        if (this.w_t.score(example.asInstance()) * y_t <= this.minMargin) {
            this.w_t.increment(example, y_t);
        }
        if (this.voteAfterTrainingComplete || this.voteBeforeTrainingComplete) {
            this.s_t.increment(this.w_t, 1.0);
        }
    }

    public void completeTraining() {
        this.trainingComplete = true;
        this.s_t.multiply(1.0 / this.numExamples);
    }

    public Classifier getClassifier() {
        if (this.voteBeforeTrainingComplete) {
            return this.s_t;
        }
        if (this.voteAfterTrainingComplete && this.trainingComplete) {
            return this.s_t;
        }
        return this.w_t;
    }

    public String toString() {
        return "[MarginPerceptron " + this.minMargin + ";" + this.voteBeforeTrainingComplete + ";" + this.voteAfterTrainingComplete + "]";
    }
}

