/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.algorithms.random.Arithmetic;
import edu.cmu.minorthird.util.MathUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NegativeBinomialClassifier
extends BinaryClassifier
implements Visible,
Serializable {
    static final long serialVersionUID = 20080130L;
    private double SCALE;
    private double priorPos;
    private double priorNeg;
    private SortedMap<Feature, SortedMap<String, Double>> pmsFeatureGivenPos;
    private SortedMap<Feature, SortedMap<String, Double>> pmsFeatureGivenNeg = new TreeMap<Feature, SortedMap<String, Double>>();

    public NegativeBinomialClassifier() {
        this.pmsFeatureGivenPos = new TreeMap<Feature, SortedMap<String, Double>>();
    }

    @Override
    public double score(Instance instance) {
        double totCnt = 0.0;
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            totCnt += instance.getWeight(f);
        }
        double score = 0.0;
        Iterator<Feature> i2 = instance.featureIterator();
        while (i2.hasNext()) {
            Feature f = i2.next();
            score += this.logOddsNB(f, instance.getWeight(f), totCnt / this.SCALE);
        }
        return score += Math.log(this.priorPos / this.priorNeg);
    }

    @Override
    public String explain(Instance instance) {
        double totCnt = 0.0;
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            totCnt += instance.getWeight(f);
        }
        StringBuffer buf = new StringBuffer("");
        Iterator<Feature> i2 = instance.featureIterator();
        while (i2.hasNext()) {
            Feature f = i2.next();
            try {
                double x = instance.getWeight(f);
                SortedMap mdn = (SortedMap)this.pmsFeatureGivenNeg.get(f);
                double mNeg = (Double)mdn.get("mu");
                SortedMap mdp = (SortedMap)this.pmsFeatureGivenPos.get(f);
                double mPos = (Double)mdp.get("mu");
                if (buf.length() > 0) {
                    buf.append(" + ");
                }
                buf.append(f + " <" + x + "*" + Math.log(mPos / mNeg) + "-" + totCnt / this.SCALE + "*" + (mPos - mNeg) + ">");
            }
            catch (Exception e) {
                System.out.println("warning:" + e);
            }
        }
        buf.append(" + bias<" + Math.log(this.priorPos / this.priorNeg) + ">");
        buf.append(" = " + this.score(instance));
        return buf.toString();
    }

    @Override
    public Explanation getExplanation(Instance instance) {
        Explanation ex = new Explanation(this.explain(instance));
        return ex;
    }

    public void setScale(double value) {
        this.SCALE = value;
    }

    public void setPriorPos(double k, double n, double prior, double pseudoCounts) {
        this.priorPos = (k + prior * pseudoCounts) / (n + pseudoCounts);
    }

    public void setPriorNeg(double k, double n, double prior, double pseudoCounts) {
        this.priorNeg = (k + prior * pseudoCounts) / (n + pseudoCounts);
    }

    private double logOddsNB(Feature f, double x, double w) {
        double logOdds;
        try {
            SortedMap mdn = (SortedMap)this.pmsFeatureGivenNeg.get(f);
            double mNeg = (Double)mdn.get("mu");
            double dNeg = (Double)mdn.get("delta");
            SortedMap mdp = (SortedMap)this.pmsFeatureGivenPos.get(f);
            double mPos = (Double)mdp.get("mu");
            double dPos = (Double)mdp.get("delta");
            logOdds = dPos == 0.0 || dNeg == 0.0 ? x * Math.log(mPos / mNeg) - w * (mPos - mNeg) : Arithmetic.logGamma(x + mPos / dPos) - Arithmetic.logGamma(mPos / dPos) - Arithmetic.logGamma(x + mNeg / dNeg) + Arithmetic.logGamma(mNeg / dNeg) + x * Math.log(dPos / dNeg) - x * Math.log((1.0 + w * dPos) / (1.0 + w * dNeg));
        }
        catch (Exception e) {
            logOdds = 0.0;
        }
        return logOdds;
    }

    public void setPmsNeg(Feature f, SortedMap<String, Double> tmap) {
        this.pmsFeatureGivenNeg.put(f, tmap);
    }

    public void setPmsPos(Feature f, SortedMap<String, Double> tmap) {
        this.pmsFeatureGivenPos.put(f, tmap);
    }

    private double featureScore(Feature f, String p, String c) {
        double value = 0.0;
        try {
            if (c.equals("POS")) {
                value = (Double)((SortedMap)this.pmsFeatureGivenPos.get(f)).get(p);
            } else if (c.equals("NEG")) {
                value = (Double)((SortedMap)this.pmsFeatureGivenNeg.get(f)).get(p);
            }
        }
        catch (Exception e) {
            System.out.println("error: ... in NB.toGui.featureScore(" + f + "," + p + "," + c + ")");
            System.exit(1);
        }
        return value;
    }

    public Iterator<Feature> featureIterator() {
        return this.pmsFeatureGivenPos.keySet().iterator();
    }

    @Override
    public Viewer toGUI() {
        ControlledViewer gui = new ControlledViewer(new MyViewer(), new NegBinControls());
        gui.setContent(this);
        return gui;
    }

    public String toString() {
        String a = this.pmsFeatureGivenNeg.toString();
        String b = this.pmsFeatureGivenPos.toString();
        return "Neg: " + a + "\n" + "Pos: " + b;
    }

    private static class MyViewer
    extends ComponentViewer
    implements Controllable {
        static final long serialVersionUID = 20080130L;
        private NegBinControls controls = null;
        private NegativeBinomialClassifier h = null;

        private MyViewer() {
        }

        public void applyControls(ViewerControls controls) {
            this.controls = (NegBinControls)controls;
            this.setContent(this.h, true);
            this.revalidate();
        }

        public boolean canReceive(Object o) {
            return o instanceof Hyperplane;
        }

        public JComponent componentFor(Object o) {
            this.h = (NegativeBinomialClassifier)o;
            Object[] keys = this.h.pmsFeatureGivenNeg.keySet().toArray();
            Object[][] tableData = new Object[keys.length][5];
            int k = 0;
            Iterator<Feature> i = this.h.featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                tableData[k][0] = f;
                tableData[k][1] = new Double(this.h.featureScore(f, "mu", "NEG"));
                tableData[k][2] = new Double(this.h.featureScore(f, "delta", "NEG"));
                tableData[k][3] = new Double(this.h.featureScore(f, "mu", "POS"));
                tableData[k][4] = new Double(this.h.featureScore(f, "delta", "POS"));
                ++k;
            }
            if (this.controls != null) {
                Arrays.sort(tableData, new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] ra, Object[] rb) {
                        if (MyViewer.this.controls.nameButton.isSelected()) {
                            return ra[0].toString().compareTo(rb[0].toString());
                        }
                        Double da = (Double)ra[1];
                        Double db = (Double)rb[1];
                        if (MyViewer.this.controls.valueButton.isSelected()) {
                            return MathUtil.sign(db - da);
                        }
                        return MathUtil.sign(Math.abs(db) - Math.abs(da));
                    }
                });
            }
            Object[] columnNames = new String[]{"Feature Name", "mu Neg", "delta Neg", "mu Pos", "delta Pos"};
            JTable table = new JTable(tableData, columnNames);
            this.monitorSelections(table, 0);
            return new JScrollPane(table);
        }
    }

    private static class NegBinControls
    extends ViewerControls {
        static final long serialVersionUID = 20080130L;
        private JRadioButton valueButton;
        private JRadioButton nameButton;

        private NegBinControls() {
        }

        public void initialize() {
            this.add(new JLabel("Sort by"));
            ButtonGroup group = new ButtonGroup();
            this.nameButton = this.addButton("name", group, true);
            this.valueButton = this.addButton("weight", group, false);
        }

        private JRadioButton addButton(String s, ButtonGroup group, boolean selected) {
            JRadioButton button = new JRadioButton(s, selected);
            group.add(button);
            this.add(button);
            button.addActionListener(this);
            return button;
        }
    }
}

