/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.algorithms.linear.Winnow;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.Iterator;

public class VitorBalancedWinnow
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20071130L;
    private Hyperplane pos_t;
    private Hyperplane neg_t;
    private Hyperplane vpos_t;
    private Hyperplane vneg_t;
    private double theta = 1.0;
    private double alpha;
    private double beta;
    private int excount;
    private double margin = 1.0;
    private boolean voted;
    private double W_MAX = Math.pow(2.0, 200.0);
    private double W_MIN = 1.0 / Math.pow(2.0, 200.0);
    private int votedCount = 0;

    public VitorBalancedWinnow() {
        this(1.5, 0.5, false);
    }

    public VitorBalancedWinnow(boolean voted) {
        this(1.5, 0.5, voted);
    }

    public VitorBalancedWinnow(double alpha, double beta, boolean voted) {
        if (alpha < 1.0 || beta < 0.0 || beta > 1.0) {
            System.err.println("Error in BalancedWinnow initial parameters");
            throw new IllegalArgumentException("invalid parameter initializing VitorBalancedWinnow. Possible Problema: (theta<0)||(alpha < 1)||(beta<0)||(beta>1)");
        }
        this.alpha = alpha;
        this.beta = beta;
        this.voted = voted;
        this.reset();
    }

    public void reset() {
        this.pos_t = new Hyperplane();
        this.neg_t = new Hyperplane();
        this.excount = 0;
        this.votedCount = 0;
        if (this.voted) {
            this.vpos_t = new Hyperplane();
            this.vneg_t = new Hyperplane();
        }
    }

    public void addExample(Example example2) {
        double y_t_hat;
        ++this.excount;
        Example example = Winnow.normalizeWeights(example2, true);
        Iterator<Feature> j = example.asInstance().featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            if (this.pos_t.hasFeature(f)) continue;
            this.pos_t.increment(f, 2.0);
            this.neg_t.increment(f, 1.0);
        }
        double y_t = example.getLabel().numericLabel();
        if (y_t * (y_t_hat = this.pos_t.score(example.asInstance()) - this.neg_t.score(example.asInstance()) - this.theta) <= this.margin) {
            if (this.voted) {
                if (this.votedCount == 0) {
                    this.updateVotedHyperplane(1);
                } else {
                    this.updateVotedHyperplane(this.votedCount);
                }
                this.votedCount = 1;
            }
            if (example.getLabel().isPositive()) {
                Iterator<Feature> j2 = example.featureIterator();
                while (j2.hasNext()) {
                    Feature f = j2.next();
                    if (this.pos_t.featureScore(f) < this.W_MAX) {
                        this.pos_t.multiply(f, (1.0 + example.getWeight(f)) * this.alpha);
                    }
                    if (!(this.neg_t.featureScore(f) > this.W_MIN)) continue;
                    this.neg_t.multiply(f, (1.0 - example.getWeight(f)) * this.beta);
                }
            } else {
                Iterator<Feature> j3 = example.featureIterator();
                while (j3.hasNext()) {
                    Feature f = j3.next();
                    if (this.pos_t.featureScore(f) > this.W_MIN) {
                        this.pos_t.multiply(f, (1.0 - example.getWeight(f)) * this.beta);
                    }
                    if (!(this.neg_t.featureScore(f) < this.W_MAX)) continue;
                    this.neg_t.multiply(f, (1.0 + example.getWeight(f)) * this.alpha);
                }
            }
        } else if (this.voted) {
            ++this.votedCount;
        }
    }

    public void updateVotedHyperplane(int count) {
        this.vpos_t.increment(this.pos_t, (double)count);
        this.vneg_t.increment(this.neg_t, (double)count);
        this.votedCount = 0;
    }

    public Classifier getClassifier() {
        if (this.voted) {
            this.updateVotedHyperplane(this.votedCount);
            Hyperplane zpos = new Hyperplane();
            Hyperplane zneg = new Hyperplane();
            zpos.increment(this.vpos_t, 1.0 / (double)this.excount);
            zneg.increment(this.vneg_t, 1.0 / (double)this.excount);
            return new MyClassifier(zpos, zneg, this.theta);
        }
        return new MyClassifier(this.pos_t, this.neg_t, this.theta);
    }

    public String toString() {
        return "VitorBalancedWinnow: voted=" + this.voted;
    }

    public class MyClassifier
    implements Classifier,
    Serializable,
    Visible {
        static final long serialVersionUID = 20071130L;
        private Hyperplane lpos_h;
        private Hyperplane lneg_h;
        private double mytheta;

        public MyClassifier(Hyperplane pos_h, Hyperplane neg_h, double atheta) {
            this.lpos_h = pos_h;
            this.lneg_h = neg_h;
            this.mytheta = atheta;
        }

        public ClassLabel classification(Instance instance1) {
            Example a1 = new Example(instance1, new ClassLabel("POS"));
            Example aa = this.filterFeat(a1);
            Example example1 = Winnow.normalizeWeights(aa, true);
            Instance instance = example1.asInstance();
            double dec = this.lpos_h.score(instance) - this.lneg_h.score(instance) - this.mytheta;
            return dec >= 0.0 ? ClassLabel.positiveLabel(dec) : ClassLabel.negativeLabel(dec);
        }

        public Example filterFeat(Example ex) {
            MutableInstance ins = new MutableInstance();
            Iterator<Feature> i = ex.asInstance().featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                if (!this.lpos_h.hasFeature(f)) continue;
                ins.addNumeric(f, ex.getWeight(f));
            }
            return new Example(ins, ex.getLabel());
        }

        public String toString() {
            return "POS = " + this.lpos_h.toString() + " NEG = " + this.lneg_h.toString();
        }

        public String explain(Instance instance) {
            return "VitorBalancedWinnow: Not implemented yet";
        }

        public Explanation getExplanation(Instance instance) {
            Explanation.Node top = new Explanation.Node("VitorBalancedWinnow Explanation");
            Explanation ex = new Explanation(top);
            return ex;
        }

        public Viewer toGUI() {
            TransformedViewer v = new TransformedViewer(new SmartVanillaViewer()){
                static final long serialVersionUID = 20071130L;

                public Object transform(Object o) {
                    MyClassifier mycl = (MyClassifier)o;
                    return mycl.lpos_h;
                }
            };
            v.setContent(this);
            return v;
        }
    }
}

