/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetClassifierTeacher;
import edu.cmu.minorthird.classify.DatasetIndex;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.RandomAccessDataset;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.algorithms.linear.NaiveBayes;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.MessageViewer;
import edu.cmu.minorthird.util.gui.VanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ClassifiedDataset
implements Visible {
    private Classifier classifier;
    private RandomAccessDataset dataset;
    private DatasetIndex index;

    public ClassifiedDataset(Classifier classifier, Dataset dataset) {
        this(classifier, dataset, new DatasetIndex(dataset));
    }

    public ClassifiedDataset(Classifier classifier, Dataset dataset, DatasetIndex index) {
        this.classifier = classifier;
        if (dataset instanceof RandomAccessDataset) {
            this.dataset = (RandomAccessDataset)dataset;
        } else {
            this.dataset = new RandomAccessDataset();
            Iterator<Example> i = dataset.iterator();
            while (i.hasNext()) {
                this.dataset.add(i.next());
            }
        }
        this.index = index;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Viewer toGUI() {
        MessageViewer v = new MessageViewer(new MyViewer());
        v.setContent(this);
        return v;
    }

    public static void main(String[] args) {
        Dataset train = SampleDatasets.sampleData("toy", false);
        NaiveBayes learner = new NaiveBayes();
        Classifier cl = new DatasetClassifierTeacher(train).train(learner);
        Dataset test = SampleDatasets.sampleData("toy", true);
        ClassifiedDataset cd = new ClassifiedDataset(cl, test);
        new ViewerFrame("ClassifiedDataset", cd.toGUI());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;
        private Viewer instanceViewer;
        private Viewer classifierViewer;
        private Viewer explanationViewer;
        private ControlledViewer dataViewer;
        private ClassifiedDataset cd;

        private MyViewer() {
        }

        @Override
        public JComponent componentFor(Object o) {
            this.cd = (ClassifiedDataset)o;
            JSplitPane left = new JSplitPane();
            left.setOrientation(0);
            left.setResizeWeight(0.75);
            this.dataViewer = new ControlledViewer(new ControlledDataViewer(), new DataControls());
            this.dataViewer.setContent(this.cd);
            left.setTopComponent(this.dataViewer);
            this.instanceViewer = GUI.newSourcedExampleViewer();
            left.setBottomComponent(this.instanceViewer);
            this.dataViewer.setSuperView(this, "data");
            this.instanceViewer.setSuperView(this, "instance");
            JSplitPane right = new JSplitPane();
            right.setOrientation(0);
            right.setResizeWeight(0.75);
            this.classifierViewer = this.cd.classifier instanceof Visible ? ((Visible)((Object)this.cd.classifier)).toGUI() : new VanillaViewer(this.cd.classifier);
            right.setTopComponent(this.classifierViewer);
            this.explanationViewer = new ExplanationViewer(new Explanation("[explanation]"));
            right.setBottomComponent(this.explanationViewer);
            this.classifierViewer.setSuperView(this, "classifier");
            this.explanationViewer.setSuperView(this, "explanation");
            JSplitPane split = new JSplitPane();
            split.setOrientation(1);
            split.setResizeWeight(0.5);
            split.setLeftComponent(left);
            split.setRightComponent(right);
            Evaluation e = new Evaluation(this.cd.dataset.getSchema());
            e.extend(this.cd.classifier, this.cd.dataset, 0);
            Viewer evalViewer = e.toGUI();
            JTabbedPane main = new JTabbedPane();
            main.add("Details", split);
            main.add("Evaluation", evalViewer);
            evalViewer.setSuperView(this, "evaluation");
            return main;
        }

        @Override
        protected boolean canHandle(int signal, Object argument, List<Viewer> senders) {
            return signal == 3 && argument instanceof Example || signal == 3 && argument instanceof Feature;
        }

        @Override
        protected void handle(int signal, Object argument, List<Viewer> senders) {
            if (argument instanceof Example) {
                Example example = (Example)argument;
                this.instanceViewer.setContent(example);
                this.explanationViewer.setContent(this.cd.classifier.getExplanation(example));
                this.revalidate();
            } else if (argument instanceof Feature) {
                DataControls dc = (DataControls)this.dataViewer.getControls();
                dc.targetFeature = (Feature)argument;
                dc.filterOnFeatureBox.setText(argument.toString());
                this.sendSignal(2, this.featureSummary((Feature)argument, this.cd.index));
            }
        }

        private String featureSummary(Feature f, DatasetIndex index) {
            Integer count;
            StringBuffer buf = new StringBuffer(f.toString());
            buf.append(" appears in ");
            buf.append(index.size(f));
            buf.append(" examples:");
            TreeMap<String, Integer> map = new TreeMap<String, Integer>();
            for (int i = 0; i < index.size(f); ++i) {
                String label = index.getExample(f, i).getLabel().bestClassName();
                count = (Integer)map.get(label);
                if (count == null) {
                    count = new Integer(0);
                    map.put(label, count);
                }
                map.put(label, new Integer(count + 1));
            }
            for (String label : map.keySet()) {
                count = (Integer)map.get(label);
                buf.append(" " + count + ":" + label);
            }
            return buf.toString();
        }
    }

    public static class ExplanationViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;
        Explanation ex;

        public ExplanationViewer(Explanation ex) {
            this.ex = ex;
            this.setContent(ex);
        }

        public boolean canReceive(Object o) {
            return o instanceof Explanation;
        }

        public JComponent componentFor(Object o) {
            this.ex = (Explanation)o;
            JScrollPane p = new JScrollPane(this.ex.getExplanation());
            return p;
        }
    }

    private static class ControlledDataViewer
    extends ComponentViewer
    implements Controllable {
        static final long serialVersionUID = 20080130L;
        private ClassifiedDataset cd;
        private boolean filterOnCorrectness = false;
        private boolean targetCorrectness = false;
        private boolean filterOnFeature = false;
        private Feature targetFeature = null;

        private ControlledDataViewer() {
        }

        public void applyControls(ViewerControls controls) {
            DataControls dc = (DataControls)controls;
            if (dc.allButton.isSelected()) {
                this.filterOnCorrectness = false;
            } else {
                this.filterOnCorrectness = true;
                this.targetCorrectness = dc.correctButton.isSelected();
            }
            this.filterOnFeature = dc.filterOnFeatureBox.isSelected();
            this.targetFeature = dc.targetFeature;
            this.receiveContent(this.cd);
            this.revalidate();
        }

        public JComponent componentFor(Object o) {
            this.cd = (ClassifiedDataset)o;
            JTable jtable = new JTable(new MyTableModel(this.filteredClassifiedDataset()));
            jtable.setDefaultRenderer(Example.class, new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return GUI.conciseExampleRendererComponent((Example)value, 60, isSelected);
                }
            });
            this.monitorSelections(jtable, 1);
            JScrollPane scrollpane = new JScrollPane(jtable);
            scrollpane.setHorizontalScrollBarPolicy(30);
            return scrollpane;
        }

        private ClassifiedDataset filteredClassifiedDataset() {
            if (!this.filterOnCorrectness && !this.filterOnFeature) {
                return this.cd;
            }
            RandomAccessDataset filteredData = new RandomAccessDataset();
            ProgressCounter pc = new ProgressCounter("classifying for ClassifiedDataset", "example", filteredData.size());
            Iterator<Example> i = this.cd.dataset.iterator();
            while (i.hasNext()) {
                Example e = i.next();
                boolean pass1 = true;
                if (this.filterOnCorrectness) {
                    pass1 = this.targetCorrectness == this.cd.classifier.classification(e).isCorrect(e.getLabel());
                }
                boolean pass2 = true;
                if (this.filterOnFeature) {
                    boolean bl = pass2 = this.targetFeature == null || e.getWeight(this.targetFeature) > 0.0;
                }
                if (pass1 && pass2) {
                    filteredData.add(e);
                }
                pc.progress();
            }
            pc.finished();
            return new ClassifiedDataset(this.cd.classifier, filteredData, this.cd.index);
        }

        private class MyTableModel
        extends AbstractTableModel {
            static final long serialVersionUID = 20080130L;
            private ClassifiedDataset cd;

            public MyTableModel(ClassifiedDataset cd) {
                this.cd = cd;
            }

            public int getRowCount() {
                return this.cd.dataset.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return this.cd.classifier.classification(this.cd.dataset.getExample(row));
                }
                if (col == 1) {
                    return this.cd.dataset.getExample(row);
                }
                throw new IllegalArgumentException("illegal col " + col);
            }

            public String getColumnName(int col) {
                if (col == 0) {
                    return "Prediction";
                }
                if (col == 1) {
                    return "Example";
                }
                throw new IllegalArgumentException("illegal col " + col);
            }
        }
    }

    private static class DataControls
    extends ViewerControls {
        static final long serialVersionUID = 20080130L;
        public JCheckBox filterOnFeatureBox;
        public Feature targetFeature;
        public JRadioButton correctButton;
        public JRadioButton incorrectButton;
        public JRadioButton allButton;

        private DataControls() {
        }

        public void initialize() {
            this.filterOnFeatureBox = new JCheckBox();
            this.filterOnFeatureBox.setText("[none]");
            this.targetFeature = null;
            this.add(this.filterOnFeatureBox);
            ButtonGroup group = new ButtonGroup();
            this.correctButton = this.addButton("correct", false, group);
            this.incorrectButton = this.addButton("incorrect", false, group);
            this.allButton = this.addButton("all", true, group);
            this.addApplyButton();
        }

        private JRadioButton addButton(String s, boolean selected, ButtonGroup group) {
            JRadioButton button = new JRadioButton(s, selected);
            group.add(button);
            this.add(button);
            return button;
        }
    }
}

