/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.Example;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrataSorter {
    private Map<String, List<Example>> labelMap = new TreeMap<String, List<Example>>();
    private List<String> strataList;

    public StrataSorter(Random random2, Iterator<Example> i) {
        while (i.hasNext()) {
            List<Example> list;
            Example example = i.next();
            String id = null;
            id = example.getLabel().bestClassName();
            if (id == null) {
                System.out.println("Error: unlabeled example!");
            }
            if ((list = this.labelMap.get(id)) == null) {
                list = new ArrayList<Example>();
                this.labelMap.put(id, list);
            }
            list.add(example);
        }
        this.strataList = new ArrayList<String>(this.labelMap.keySet().size());
        for (String key : this.labelMap.keySet()) {
            Collections.shuffle(this.labelMap.get(key), random2);
            this.strataList.add(key);
        }
        Collections.shuffle(this.strataList, random2);
    }

    public StrataSorter(Iterator<Example> i) {
        this(new Random(), i);
    }

    public Iterator<List<Example>> strataIterator() {
        return new HisIterator(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HisIterator
    implements Iterator<List<Example>> {
        private int i;

        public HisIterator(int i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i < StrataSorter.this.strataList.size();
        }

        @Override
        public List<Example> next() {
            return (List)StrataSorter.this.labelMap.get(StrataSorter.this.strataList.get(this.i++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }
    }
}

