/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.HasSubpopulationId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubpopSorter<T> {
    private SortedMap<String, List<T>> clusterMap = new TreeMap<String, List<T>>();
    private List<String> subpopList;
    private int nextUniqId = 0;

    public SubpopSorter(Random random2, Iterator<T> i) {
        while (i.hasNext()) {
            ArrayList<T> list;
            T instance = i.next();
            String id = null;
            if (instance instanceof HasSubpopulationId) {
                id = ((HasSubpopulationId)instance).getSubpopulationId();
            }
            if (id == null) {
                id = "youNeeekID#" + this.nextUniqId++;
            }
            if ((list = (ArrayList<T>)this.clusterMap.get(id)) == null) {
                list = new ArrayList<T>();
                this.clusterMap.put(id, list);
            }
            list.add(instance);
        }
        this.subpopList = new ArrayList<String>(this.clusterMap.keySet().size());
        for (String key : this.clusterMap.keySet()) {
            Collections.shuffle((List)this.clusterMap.get(key), random2);
            this.subpopList.add(key);
        }
        Collections.shuffle(this.subpopList, random2);
    }

    public SubpopSorter(Iterator<T> i) {
        this(new Random(), i);
    }

    public Iterator<List<T>> subpopIterator() {
        return new MyIterator(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements Iterator<List<T>> {
        private int i;

        public MyIterator(int i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i < SubpopSorter.this.subpopList.size();
        }

        @Override
        public List<T> next() {
            return (List)SubpopSorter.this.clusterMap.get(SubpopSorter.this.subpopList.get(this.i++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }
    }
}

