/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.ExampleSchema;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiClassLabel
implements Serializable {
    static final long serialVersionUID = 20080130L;
    private ClassLabel[] labels;
    private int dimensions;

    public MultiClassLabel() {
    }

    public MultiClassLabel(ClassLabel[] labels) {
        this.labels = labels;
        this.dimensions = labels.length;
    }

    public ClassLabel[] getLabels() {
        return this.labels;
    }

    public int numDimensions() {
        return this.dimensions;
    }

    public boolean[] isBinary() {
        boolean[] binary = new boolean[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            binary[i] = ExampleSchema.BINARY_EXAMPLE_SCHEMA.isValid(this.labels[i]);
        }
        return binary;
    }

    public boolean[] isPositive() {
        boolean[] positive = new boolean[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            positive[i] = "POS".equals(this.labels[i].bestClassName());
        }
        return positive;
    }

    public boolean[] isNegative() {
        boolean[] negative = new boolean[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            negative[i] = "NEG".equals(this.labels[i].bestClassName());
        }
        return negative;
    }

    public double[] numericLabel() {
        double[] numLabel = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            numLabel[i] = this.labels[i].numericLabel();
        }
        return numLabel;
    }

    public String[] bestClassName() {
        String[] bestName = new String[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            bestName[i] = this.labels[i].bestClassName();
        }
        return bestName;
    }

    public double[] bestWeight() {
        double[] bestWeight = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            bestWeight[i] = this.labels[i].bestWeight();
        }
        return bestWeight;
    }

    public double[] posWeight() {
        double[] posWeight = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            posWeight[i] = this.labels[i].getWeight("POS");
        }
        return posWeight;
    }

    public double[] posProbability() {
        double[] posProb = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            posProb[i] = this.labels[i].getProbability("POS");
        }
        return posProb;
    }

    public double[] getWeight(String[] label) {
        double[] weight = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            weight[i] = this.labels[i].getWeight(label[i]);
        }
        return weight;
    }

    public double[] getProbability(String[] label) {
        double[] odds = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            double expOdds = Math.exp(this.labels[i].getWeight(label[i]));
            odds[i] = expOdds / (1.0 + expOdds);
        }
        return odds;
    }

    public Set<String>[] possibleLabels() {
        Set[] sets = new Set[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            sets[i] = this.labels[i].possibleLabels();
        }
        return sets;
    }

    public boolean[] isMultiCorrect(MultiClassLabel otherLabel) {
        if (otherLabel == null) {
            throw new IllegalArgumentException("null otherLabel?");
        }
        if (this.bestClassName() == null) {
            throw new IllegalArgumentException("null bestClassName?");
        }
        if (this.dimensions != otherLabel.numDimensions()) {
            throw new IllegalArgumentException("Number of Dimensions do not match");
        }
        boolean[] correct = new boolean[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            correct[i] = this.labels[i].bestClassName().equals(otherLabel.labels[i].bestClassName());
        }
        return correct;
    }

    public boolean isCorrect(MultiClassLabel otherLabel) {
        if (otherLabel == null) {
            throw new IllegalArgumentException("null otherLabel?");
        }
        if (this.bestClassName() == null) {
            throw new IllegalArgumentException("null bestClassName?");
        }
        if (this.dimensions != otherLabel.numDimensions()) {
            throw new IllegalArgumentException("Number of Dimensions do not match");
        }
        boolean correct = true;
        for (int i = 0; i < this.dimensions; ++i) {
            correct = correct && this.labels[i].bestClassName().equals(otherLabel.labels[i].bestClassName());
        }
        return correct;
    }

    public String toString() {
        String labelString = "";
        for (int i = 0; i < this.dimensions; ++i) {
            labelString = labelString + this.labels[i].toString();
        }
        return labelString;
    }

    public String toDetails() {
        String details = "";
        for (int i = 0; i < this.dimensions; ++i) {
            details = details + this.labels[i].toDetails();
        }
        return details;
    }
}

