/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.multi.MultiClassLabel;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultiClassifier
implements Classifier,
Visible,
Serializable {
    static final long serialVersionUID = 20080130L;
    public Classifier[] classifiers;

    public MultiClassifier(Classifier[] classifiers) {
        this.classifiers = classifiers;
    }

    public MultiClassLabel multiLabelClassification(Instance instance) {
        ClassLabel[] labels = new ClassLabel[this.classifiers.length];
        for (int i = 0; i < this.classifiers.length; ++i) {
            labels[i] = this.classifiers[i].classification(instance);
        }
        MultiClassLabel multiLabel = new MultiClassLabel(labels);
        return multiLabel;
    }

    public int getNumDim() {
        return this.classifiers.length;
    }

    public ClassLabel classification(Instance instance) {
        ClassLabel classLabel = this.classifiers[0].classification(instance);
        return classLabel;
    }

    public String explain(Instance instance) {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < this.classifiers.length; ++i) {
            buf.append(this.classifiers[i].explain(instance));
            buf.append("\n");
        }
        buf.append("classification = " + this.classification(instance).toString());
        return buf.toString();
    }

    public Explanation getExplanation(Instance instance) {
        Explanation.Node top = new Explanation.Node("MultiClassifier Explanation");
        for (int i = 0; i < this.classifiers.length; ++i) {
            Explanation.Node classEx = this.classifiers[i].getExplanation(instance).getTopNode();
            top.add(classEx);
        }
        Explanation.Node score = new Explanation.Node("classification = " + this.classification(instance).toString());
        top.add(score);
        Explanation ex = new Explanation(top);
        return ex;
    }

    public Classifier[] getClassifiers() {
        return this.classifiers;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[MultiClassifier:\n");
        for (int i = 0; i < this.classifiers.length; ++i) {
            buf.append(this.classifiers[i] + "\n");
        }
        buf.append("end MultiClassifier]\n");
        return buf.toString();
    }

    public Viewer toGUI() {
        ComponentViewer v = new ComponentViewer(){
            static final long serialVersionUID = 20080130L;

            public JComponent componentFor(Object o) {
                MultiClassifier c = (MultiClassifier)o;
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                for (int i = 0; i < c.classifiers.length; ++i) {
                    JLabel label = new JLabel("Dimension: " + i);
                    label.setAlignmentX(0.5f);
                    panel.add(label);
                    SmartVanillaViewer subView = new SmartVanillaViewer();
                    subView.setContent(c.classifiers[i]);
                    subView.setSuperView(this);
                    panel.add(subView);
                }
                return new JScrollPane(panel);
            }
        };
        v.setContent(this);
        return v;
    }
}

