/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.Util;
import edu.cmu.minorthird.classify.multi.MultiClassifierTeacher;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiExample;
import edu.cmu.minorthird.classify.multi.MultiExampleSchema;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDatasetClassifierTeacher
extends MultiClassifierTeacher {
    private MultiDataset dataset;
    private boolean activeLearning = false;

    public MultiDatasetClassifierTeacher(MultiDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public MultiExampleSchema schema() {
        return this.dataset.getMultiSchema();
    }

    @Override
    public Iterator<MultiExample> examplePool() {
        if (this.activeLearning) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.dataset.multiIterator();
    }

    @Override
    public Iterator<Instance> instancePool() {
        if (this.activeLearning) {
            return Util.toInstanceIterator(this.dataset.multiIterator());
        }
        if (this.dataset instanceof MultiDataset) {
            return this.dataset.iteratorOverUnlabeled();
        }
        return Collections.EMPTY_SET.iterator();
    }

    @Override
    public MultiExample labelInstance(Instance query) {
        if (query instanceof MultiExample) {
            return (MultiExample)query;
        }
        return null;
    }

    @Override
    public boolean hasAnswers() {
        return this.activeLearning;
    }
}

