/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.multi;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.classify.multi.MultiClassifier;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiExampleSchema;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import javax.swing.JComponent;

public class MultiEvaluation
implements Visible {
    Evaluation[] evals;
    MultiExampleSchema schema;

    public MultiEvaluation(MultiExampleSchema schema) {
        this.schema = schema;
        ExampleSchema[] exSchemas = schema.getSchemas();
        this.evals = new Evaluation[exSchemas.length];
        for (int i = 0; i < this.evals.length; ++i) {
            this.evals[i] = new Evaluation(exSchemas[i]);
        }
    }

    public void extend(MultiClassifier c, MultiDataset d) {
        ProgressCounter pc = new ProgressCounter("classifying", "example", d.size());
        Classifier[] classifiers = c.getClassifiers();
        Dataset[] datasets = d.separateDatasets();
        for (int i = 0; i < this.evals.length; ++i) {
            this.evals[i].extend(classifiers[i], datasets[i], 1);
        }
        pc.progress();
        pc.finished();
    }

    public void summarize() {
        for (int i = 0; i < this.evals.length; ++i) {
            int j;
            System.out.println("Dimension: " + i);
            double[] stats = this.evals[i].summaryStatistics();
            String[] statNames = this.evals[i].summaryStatisticNames();
            int maxLen = 0;
            for (j = 0; j < statNames.length; ++j) {
                maxLen = Math.max(statNames[j].length(), maxLen);
            }
            for (j = 0; j < statNames.length; ++j) {
                System.out.print(statNames[j] + ": ");
                for (int k = 0; k < maxLen - statNames[j].length(); ++k) {
                    System.out.print(" ");
                }
                System.out.println(stats[j]);
            }
        }
    }

    public Viewer toGUI() {
        ParallelViewer main = new ParallelViewer();
        for (int i = 0; i < this.evals.length; ++i) {
            main.addSubView("Dimension: " + i, new EvaluationViewer(i));
        }
        main.setContent(this);
        return main;
    }

    public static class EvaluationViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;
        private int eval_num;

        public EvaluationViewer(int eval_num) {
            this.eval_num = eval_num;
        }

        public JComponent componentFor(Object o) {
            MultiEvaluation me = (MultiEvaluation)o;
            Evaluation e = me.evals[this.eval_num];
            return e.toGUI();
        }
    }
}

