/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.ranking;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.ranking.BatchRankingLearner;
import edu.cmu.minorthird.util.ProgressCounter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankingPerceptron
extends BatchRankingLearner {
    private int numEpochs;
    private static final double MARGIN = 0.1;

    public RankingPerceptron() {
        this(100);
    }

    public RankingPerceptron(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    @Override
    public Classifier batchTrain(Dataset data) {
        Hyperplane h = new Hyperplane();
        Hyperplane s = new Hyperplane();
        int numUpdates = 0;
        Map<String, List<Example>> rankingMap = RankingPerceptron.listsWithOneExampleEach(RankingPerceptron.splitIntoRankings(data));
        ProgressCounter pc = new ProgressCounter("perceptron training", "epoch", this.numEpochs);
        for (int e = 0; e < this.numEpochs; ++e) {
            for (String subpop : rankingMap.keySet()) {
                List<Example> ranking = rankingMap.get(subpop);
                numUpdates += this.batchTrainSubPop(h, s, ranking);
            }
            pc.progress();
        }
        pc.finished();
        s.multiply(1.0 / (double)numUpdates);
        return s;
    }

    private int batchTrainSubPop(Hyperplane h, Hyperplane s, List<Example> ranking) {
        Example exi;
        int i;
        RankingPerceptron.sortByScore(h, ranking);
        int updates = 0;
        Example highestNegativeExample = null;
        for (i = 0; i < ranking.size(); ++i) {
            exi = ranking.get(i);
            if (!exi.getLabel().isNegative()) continue;
            highestNegativeExample = ranking.get(i);
            break;
        }
        for (i = 0; i < ranking.size(); ++i) {
            exi = ranking.get(i);
            if (!exi.getLabel().isPositive()) continue;
            if (highestNegativeExample != null && h.score(exi) < h.score(highestNegativeExample) + 0.1) {
                Example pos = ranking.get(i);
                h.increment(highestNegativeExample, -1.0);
                h.increment(pos, 1.0);
            }
            s.increment(h);
            ++updates;
        }
        return updates;
    }
}

