/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.relational;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.SGMExample;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.relational.CoreRelationalDataset;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealRelationalDataset
extends CoreRelationalDataset
implements Visible,
Saveable,
Dataset,
Serializable {
    static final long serialVersionUID = 20080128L;
    protected static Map<String, Set<String>> aggregators = new HashMap<String, Set<String>>();
    public static Set<String> legalAggregators = new HashSet<String>();

    public static void addAggregator(String oper, String L_type) {
        if (legalAggregators.contains(oper)) {
            if (aggregators.containsKey(L_type)) {
                aggregators.get(L_type).add(oper);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add(oper);
                aggregators.put(L_type, (HashSet)set.clone());
            }
        } else {
            System.out.println(oper + " is not a legal aggregator");
        }
    }

    public static Map<String, Set<String>> getAggregators() {
        return aggregators;
    }

    public static void setAggregators(Map<String, Set<String>> aggregators) {
        RealRelationalDataset.aggregators = aggregators;
    }

    @Override
    public Dataset.Split split(final Splitter<Example> splitter) {
        splitter.split(this.iterator());
        return new Dataset.Split(){

            public int getNumPartitions() {
                return splitter.getNumPartitions();
            }

            public Dataset getTrain(int k) {
                return RealRelationalDataset.this.invertIteration(splitter.getTrain(k));
            }

            public Dataset getTest(int k) {
                return RealRelationalDataset.this.invertIteration(splitter.getTest(k));
            }
        };
    }

    private RealRelationalDataset invertIteration(Iterator<Example> i) {
        RealRelationalDataset copy2 = new RealRelationalDataset();
        while (i.hasNext()) {
            copy2.addSGM((SGMExample)i.next());
        }
        return copy2;
    }

    public static void main(String[] args) {
        try {
            RealRelationalDataset data = new RealRelationalDataset();
            DatasetLoader.loadRelFile(new File("test.osf"), data);
            DatasetLoader.loadLinkFile(new File("test.lsf"), data);
            DatasetLoader.loadRelTempFile(new File("relTemp.txt"), data);
            System.out.println(data.getSchema());
            System.out.println("Aggregators: " + RealRelationalDataset.getAggregators());
            for (SGMExample e : data.examples) {
                System.out.println(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        legalAggregators.add("EXISTS");
        legalAggregators.add("COUNT");
    }
}

