/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.semisupervised;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.semisupervised.SemiSupervisedActions;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemiSupervisedDataset
implements Dataset,
SemiSupervisedActions,
Visible,
Saveable {
    protected List<Example> examples = new ArrayList<Example>();
    protected List<Instance> unlabeledExamples = new ArrayList<Instance>();
    protected Set<String> classNameSet = new TreeSet<String>();
    protected FeatureFactory factory = new FeatureFactory();
    private static final String FORMAT_NAME = "Minorthird Dataset";

    @Override
    public ExampleSchema getSchema() {
        ExampleSchema schema = new ExampleSchema(this.classNameSet.toArray(new String[this.classNameSet.size()]));
        if (schema.equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA)) {
            return ExampleSchema.BINARY_EXAMPLE_SCHEMA;
        }
        return schema;
    }

    @Override
    public void addUnlabeled(Instance instance) {
        this.unlabeledExamples.add(this.factory.compress(instance));
    }

    @Override
    public Iterator<Instance> iteratorOverUnlabeled() {
        return this.unlabeledExamples.iterator();
    }

    @Override
    public int sizeUnlabeled() {
        return this.unlabeledExamples.size();
    }

    @Override
    public boolean hasUnlabeled() {
        return this.unlabeledExamples.size() > 0;
    }

    @Override
    public FeatureFactory getFeatureFactory() {
        return this.factory;
    }

    @Override
    public void add(Example example) {
        this.add(example, true);
    }

    @Override
    public void add(Example example, boolean compress) {
        if (compress) {
            this.examples.add(this.factory.compress(example));
        } else {
            this.examples.add(example);
        }
        this.classNameSet.addAll(example.getLabel().possibleLabels());
    }

    @Override
    public Iterator<Example> iterator() {
        return this.examples.iterator();
    }

    @Override
    public int size() {
        return this.examples.size();
    }

    @Override
    public void shuffle(Random r) {
        Collections.shuffle(this.examples, r);
    }

    @Override
    public void shuffle() {
        this.shuffle(new Random(999L));
    }

    @Override
    public Dataset shallowCopy() {
        BasicDataset copy2 = new BasicDataset();
        Iterator<Example> i = this.iterator();
        while (i.hasNext()) {
            copy2.add(i.next());
        }
        return copy2;
    }

    @Override
    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    @Override
    public String getExtensionFor(String s) {
        return ".data";
    }

    @Override
    public void saveAs(File file, String format) throws IOException {
        if (!format.equals(FORMAT_NAME)) {
            throw new IllegalArgumentException("illegal format " + format);
        }
        DatasetLoader.save(this, file);
    }

    @Override
    public Object restore(File file) throws IOException {
        try {
            return DatasetLoader.loadFile(file);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("error loading from " + file + ": " + ex);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        Iterator<Example> i = this.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            buf.append(ex.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public Viewer toGUI() {
        BasicDataset.SimpleDatasetViewer dbGui = new BasicDataset.SimpleDatasetViewer();
        dbGui.setContent(this);
        Viewer instGui = GUI.newSourcedExampleViewer();
        return new ZoomedViewer(dbGui, instGui);
    }

    @Override
    public Dataset.Split split(final Splitter<Example> splitter) {
        splitter.split(this.examples.iterator());
        return new Dataset.Split(){

            public int getNumPartitions() {
                return splitter.getNumPartitions();
            }

            public Dataset getTrain(int k) {
                return SemiSupervisedDataset.this.invertIteration(splitter.getTrain(k));
            }

            public Dataset getTest(int k) {
                return SemiSupervisedDataset.this.invertIteration(splitter.getTest(k));
            }
        };
    }

    private Dataset invertIteration(Iterator<Example> i) {
        BasicDataset copy2 = new BasicDataset();
        while (i.hasNext()) {
            copy2.add(i.next());
        }
        return copy2;
    }

    public static void main(String[] args) {
        try {
            BasicDataset data = (BasicDataset)SampleDatasets.sampleData("toy", false);
            new ViewerFrame("Toy Dataset", data.toGUI());
            System.out.println(data.getSchema());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumPosExamples() {
        return -1;
    }

    public static class SimpleDatasetViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080207L;

        public boolean canReceive(Object o) {
            return o instanceof Dataset;
        }

        public JComponent componentFor(Object o) {
            Dataset d = (Dataset)o;
            final Example[] tmp = new Example[d.size()];
            int k = 0;
            Iterator<Example> i = d.iterator();
            while (i.hasNext()) {
                tmp[k++] = i.next();
            }
            JList<Example> jList = new JList<Example>(tmp);
            jList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList el, Object v, int index, boolean sel, boolean focus) {
                    return GUI.conciseExampleRendererComponent(tmp[index], 60, sel);
                }
            });
            this.monitorSelections(jList);
            return new JScrollPane(jList);
        }
    }
}

