/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.BeamSearcher;
import edu.cmu.minorthird.classify.sequential.ConfidenceReportingSequenceClassifier;
import edu.cmu.minorthird.classify.sequential.ConfidenceUtils;
import edu.cmu.minorthird.classify.sequential.SequenceConstants;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class CMM
implements ConfidenceReportingSequenceClassifier,
SequenceConstants,
Visible,
Serializable {
    private static final long serialVersionUID = 20080207L;
    static Logger log = Logger.getLogger(CMM.class);
    private static final boolean DEBUG = false;
    private BeamSearcher searcher;
    private int historySize;
    private Classifier classifier;
    private int beamSize = 10;

    public CMM(Classifier classifier, int historySize, ExampleSchema schema) {
        this.searcher = new BeamSearcher(classifier, historySize, schema);
        this.classifier = classifier;
        this.historySize = historySize;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public ClassLabel[] classification(Instance[] sequence) {
        return this.searcher.bestLabelSequence(sequence);
    }

    public double confidence(Instance[] sequence, ClassLabel[] predictedClasses, ClassLabel[] alternateClasses, int lo, int hi) {
        if (predictedClasses.length != alternateClasses.length || predictedClasses.length != sequence.length) {
            throw new IllegalArgumentException("predictedClasses, alternateClasses, sequence should be parallel arrays");
        }
        if (lo < 0 || lo > sequence.length || hi < 0 || hi > sequence.length || hi <= lo) {
            throw new IllegalArgumentException("lo..hi must be define a subsequence");
        }
        this.searcher.doSearch(sequence, alternateClasses);
        ClassLabel[] constrainedPrediction = this.searcher.viterbi(0);
        double weightOfPrediction = ConfidenceUtils.sumPredictedWeights(predictedClasses, 0, predictedClasses.length);
        double weightOfConstrainedPrediction = ConfidenceUtils.sumPredictedWeights(constrainedPrediction, 0, constrainedPrediction.length);
        if (weightOfConstrainedPrediction > weightOfPrediction) {
            throw new IllegalStateException("constrained beam search should have returned a lower-scoring prediction?");
        }
        return weightOfPrediction - weightOfConstrainedPrediction;
    }

    public String explain(Instance[] sequence) {
        return this.searcher.explain(sequence);
    }

    public Explanation getExplanation(Instance[] sequence) {
        Explanation.Node top = new Explanation.Node("CMM Explanation");
        Explanation.Node searcherEx = this.searcher.getExplanation(sequence).getTopNode();
        if (searcherEx == null) {
            searcherEx = new Explanation.Node(this.searcher.explain(sequence));
        }
        top.add(searcherEx);
        Explanation ex = new Explanation(top);
        return ex;
    }

    public Viewer toGUI() {
        ComponentViewer v = new ComponentViewer(){
            static final long serialVersionUID = 20080207L;

            public JComponent componentFor(Object o) {
                CMM cmm = (CMM)o;
                JPanel mainPanel = new JPanel();
                mainPanel.setLayout(new BorderLayout());
                mainPanel.add((Component)new JLabel("CMM: historySize=" + cmm.historySize + " beamSize=" + CMM.this.beamSize), "North");
                SmartVanillaViewer subView = new SmartVanillaViewer(cmm.classifier);
                subView.setSuperView(this);
                mainPanel.add((Component)subView, "South");
                mainPanel.setBorder(new TitledBorder("Conditional Markov Model"));
                return new JScrollPane(mainPanel);
            }
        };
        v.setContent(this);
        return v;
    }
}

