/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.algorithms.svm.SVMLearner;
import edu.cmu.minorthird.classify.sequential.BatchSequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.CMM;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import java.util.Iterator;

public class CMMLearner
implements BatchSequenceClassifierLearner {
    private ClassifierLearner baseLearner;
    private int historySize;

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int newHistorySize) {
        this.historySize = newHistorySize;
    }

    public CMMLearner() {
        this(new SVMLearner(), 3);
    }

    public CMMLearner(ClassifierLearner baseLearner, int historySize) {
        this.baseLearner = baseLearner;
        this.historySize = historySize;
    }

    public void setSchema(ExampleSchema schema) {
    }

    public SequenceClassifier batchTrain(SequenceDataset dataset) {
        ExampleSchema schema = dataset.getSchema();
        this.baseLearner.reset();
        this.baseLearner.setSchema(schema);
        dataset.setHistorySize(this.historySize);
        Iterator<Example> i = dataset.iterator();
        while (i.hasNext()) {
            Example e = i.next();
            this.baseLearner.addExample(e);
        }
        Classifier classifier = this.baseLearner.getClassifier();
        return new CMM(classifier, this.historySize, schema);
    }
}

