/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.sequential.CMM;
import edu.cmu.minorthird.classify.sequential.CollinsPerceptronLearner;
import edu.cmu.minorthird.classify.sequential.SequenceConstants;
import edu.cmu.minorthird.classify.sequential.SequenceUtils;
import org.apache.log4j.Logger;

public class CMMTweaker
implements SequenceConstants {
    private static Logger log = Logger.getLogger(CMMTweaker.class);
    private static double oldBias = -1.0;
    private static double newBias = -1.0;

    public double oldBias() {
        return oldBias;
    }

    public double newBias() {
        return newBias;
    }

    public CMM tweak(CMM cmm, double bias) {
        Classifier c = cmm.getClassifier();
        if (c instanceof CollinsPerceptronLearner.MultiClassVPClassifier) {
            CollinsPerceptronLearner.MultiClassVPClassifier mc = (CollinsPerceptronLearner.MultiClassVPClassifier)c;
            Hyperplane[] h = mc.getHyperplanes();
            ExampleSchema schema = mc.getSchema();
            int histSize = cmm.getHistorySize();
            return new CMM(new SequenceUtils.MultiClassClassifier(schema, (Classifier[])this.tweak(h, schema, bias)), histSize, schema);
        }
        if (c instanceof SequenceUtils.MultiClassClassifier) {
            SequenceUtils.MultiClassClassifier mc = (SequenceUtils.MultiClassClassifier)c;
            Classifier[] bc = mc.getBinaryClassifiers();
            Hyperplane[] h = new Hyperplane[bc.length];
            for (int i = 0; i < bc.length; ++i) {
                if (!(bc[i] instanceof Hyperplane)) {
                    throw new IllegalArgumentException("invalid type of MultiClassClassifier: contains " + bc[i].getClass());
                }
                h[i] = (Hyperplane)bc[i];
            }
            ExampleSchema schema = mc.getSchema();
            int histSize = cmm.getHistorySize();
            return new CMM(new SequenceUtils.MultiClassClassifier(schema, (Classifier[])this.tweak(h, schema, bias)), histSize, schema);
        }
        throw new IllegalArgumentException("invalid type of CMM classifier " + c.getClass());
    }

    private Hyperplane[] tweak(Hyperplane[] h, ExampleSchema schema, double bias) {
        Hyperplane[] tweakedH = new Hyperplane[h.length];
        for (int i = 0; i < h.length; ++i) {
            tweakedH[i] = h[i];
        }
        int n = schema.getClassIndex("NEG");
        tweakedH[n] = new Hyperplane();
        tweakedH[n].increment(h[n]);
        tweakedH[n].setBias(bias);
        oldBias = h[n].featureScore(Hyperplane.BIAS_TERM);
        newBias = bias;
        log.info("bias term for NEG hyperplane: " + oldBias + " => " + bias);
        return tweakedH;
    }
}

