/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.experiments.ClassifiedDataset;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClassifiedSequenceDataset
implements Visible {
    private SequenceDataset sequenceDataset;
    private Classifier adaptedClassifier;

    public ClassifiedSequenceDataset(SequenceClassifier sequenceClassifier, SequenceDataset sequenceDataset) {
        this.sequenceDataset = sequenceDataset;
        this.adaptedClassifier = new AdaptedSequenceClassifier(sequenceClassifier, sequenceDataset);
    }

    public Classifier getClassifier() {
        return this.adaptedClassifier;
    }

    public Viewer toGUI() {
        Viewer cdv = new ClassifiedDataset(this.adaptedClassifier, this.sequenceDataset).toGUI();
        TransformedViewer v = new TransformedViewer(cdv){
            static final long serialVersionUID = 20080207L;

            public Object transform(Object o) {
                ClassifiedSequenceDataset csd = (ClassifiedSequenceDataset)o;
                return new ClassifiedDataset(csd.adaptedClassifier, csd.sequenceDataset);
            }
        };
        v.setContent(this);
        return v;
    }

    private static class AdaptedSequenceClassifier
    implements Classifier,
    Visible {
        private SequenceClassifier sequenceClassifier;
        private Map<Object, Place> instanceToPlace = new HashMap<Object, Place>();
        private Map<Example[], ClassLabel[]> classifiedSeq = new HashMap<Example[], ClassLabel[]>();
        private Map<Example[], String> explainedSeq = new HashMap<Example[], String>();

        public AdaptedSequenceClassifier(SequenceClassifier sequenceClassifier, SequenceDataset sequenceDataset) {
            this.sequenceClassifier = sequenceClassifier;
            Iterator<Example[]> i = sequenceDataset.sequenceIterator();
            while (i.hasNext()) {
                Example[] seq = i.next();
                for (int j = 0; j < seq.length; ++j) {
                    this.instanceToPlace.put(seq[j].getSource(), new Place(seq, j));
                }
            }
        }

        public ClassLabel classification(Instance instance) {
            Place place = this.instanceToPlace.get(instance.getSource());
            if (place == null) {
                throw new IllegalArgumentException("instance src" + instance.getSource() + " not in " + this.instanceToPlace);
            }
            ClassLabel[] labelSeq = this.classifiedSeq.get(place.seq);
            if (labelSeq == null) {
                labelSeq = this.sequenceClassifier.classification(place.seq);
                this.classifiedSeq.put(place.seq, labelSeq);
            }
            return labelSeq[place.index];
        }

        public String explain(Instance instance) {
            Place place = this.instanceToPlace.get(instance.getSource());
            if (place == null) {
                throw new IllegalArgumentException("no explanation available");
            }
            String explanation = this.explainedSeq.get(place.seq);
            if (explanation == null) {
                explanation = this.sequenceClassifier.explain(place.seq);
                this.explainedSeq.put(place.seq, explanation);
            }
            return explanation;
        }

        public Explanation getExplanation(Instance instance) {
            Place place = this.instanceToPlace.get(instance.getSource());
            if (place == null) {
                throw new IllegalArgumentException("no explanation available");
            }
            Explanation ex = this.sequenceClassifier.getExplanation(place.seq);
            return ex;
        }

        public Viewer toGUI() {
            return new SmartVanillaViewer(this.sequenceClassifier);
        }

        private class Place {
            Example[] seq;
            int index;

            public Place(Example[] seq, int index) {
                this.seq = seq;
                this.index = index;
            }
        }
    }
}

