/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.AbstractInstance;
import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.sequential.CandidateSegmentGroup;
import gnu.trove.THashSet;
import gnu.trove.TObjectDoubleHashMap;
import gnu.trove.TObjectProcedure;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactCandidateSegmentGroup
implements CandidateSegmentGroup,
Serializable {
    static final long serialVersionUID = 20080207L;
    private int maxWindowSize;
    private int sequenceLength;
    private int totalSize;
    private Set<String> classNameSet;
    private String subPopId;
    private Instance[] unitInstance;
    private Delta[][] delta;
    private ClassLabel[][] label;
    private Object[][] segmentSource;

    public CompactCandidateSegmentGroup(FeatureFactory factory, CandidateSegmentGroup group) {
        int i;
        this.sequenceLength = group.getSequenceLength();
        this.maxWindowSize = group.getMaxWindowSize();
        this.totalSize = group.size();
        this.classNameSet = group.classNameSet();
        this.subPopId = group.getSubpopulationId();
        this.unitInstance = new Instance[this.sequenceLength];
        this.delta = new Delta[this.sequenceLength][this.maxWindowSize];
        this.label = new ClassLabel[this.sequenceLength][this.maxWindowSize];
        this.segmentSource = new Object[this.sequenceLength][this.maxWindowSize];
        for (i = 0; i < this.sequenceLength; ++i) {
            this.unitInstance[i] = factory.compress(group.getSubsequenceInstance(i, i + 1));
        }
        for (i = 0; i < this.sequenceLength; ++i) {
            int j = i + 1;
            while (j - i <= this.maxWindowSize) {
                if (group.getSubsequenceInstance(i, j) != null) {
                    this.label[i][j - i - 1] = group.getSubsequenceLabel(i, j);
                    this.segmentSource[i][j - i - 1] = group.getSubsequenceInstance(i, j).getSource();
                    this.delta[i][j - i - 1] = new Delta(factory, i, j, group.getSubsequenceInstance(i, j));
                }
                ++j;
            }
        }
    }

    private Set<Feature> binaryFeatureSet(int start, int end, Instance otherInstance) {
        HashSet<Feature> s = new HashSet<Feature>();
        for (int i = start; i < end; ++i) {
            this.addAll(s, this.unitInstance[i].binaryFeatureIterator());
        }
        if (otherInstance != null) {
            this.addAll(s, otherInstance.binaryFeatureIterator());
        }
        return s;
    }

    private Set<Feature> numericFeatureSet(int start, int end, Instance otherInstance) {
        HashSet<Feature> s = new HashSet<Feature>();
        for (int i = start; i < end; ++i) {
            this.addAll(s, this.unitInstance[i].numericFeatureIterator());
        }
        if (otherInstance != null) {
            this.addAll(s, otherInstance.numericFeatureIterator());
        }
        return s;
    }

    private Set<Feature> featureSet(int start, int end, Instance otherInstance) {
        HashSet<Feature> s = new HashSet<Feature>();
        s.addAll(this.binaryFeatureSet(start, end, otherInstance));
        s.addAll(this.numericFeatureSet(start, end, otherInstance));
        return s;
    }

    private void addAll(Set<Feature> s, Iterator<Feature> i) {
        while (i.hasNext()) {
            s.add(i.next());
        }
    }

    private double getSumWeight(int start, int end, Feature f) {
        double w = 0.0;
        for (int i = start; i < end; ++i) {
            w += this.unitInstance[i].getWeight(f);
        }
        return w;
    }

    @Override
    public Example getSubsequenceExample(int start, int end) {
        if (end - start == 1) {
            return new Example(this.unitInstance[start], this.label[start][0]);
        }
        if (this.delta[start][end - start - 1] != null) {
            return new Example(new DeltaInstance(start, end), this.label[start][end - start - 1]);
        }
        return null;
    }

    @Override
    public ClassLabel getSubsequenceLabel(int start, int end) {
        return this.label[start][end - start - 1];
    }

    @Override
    public Instance getSubsequenceInstance(int start, int end) {
        if (end - start == 1) {
            return new Example(this.unitInstance[start], this.label[start][0]);
        }
        if (this.delta[start][end - start - 1] != null) {
            return new DeltaInstance(start, end);
        }
        return null;
    }

    @Override
    public int getSequenceLength() {
        return this.sequenceLength;
    }

    @Override
    public int getMaxWindowSize() {
        return this.maxWindowSize;
    }

    @Override
    public String getSubpopulationId() {
        return this.subPopId;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public Set<String> classNameSet() {
        return this.classNameSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeltaInstance
    extends AbstractInstance
    implements Serializable {
        static final long serialVersionUID = 20080207L;
        private int start;
        private int end;
        private Delta diff;

        public DeltaInstance(int start, int end) {
            this.start = start;
            this.end = end;
            this.diff = CompactCandidateSegmentGroup.this.delta[start][end - start - 1];
            this.source = CompactCandidateSegmentGroup.this.segmentSource[start][end - start - 1];
            this.subpopulationId = CompactCandidateSegmentGroup.this.subPopId;
        }

        public DeltaInstance(int start, int end, Delta initDelta, Object initSource, String initSubPopId) {
            this.start = start;
            this.end = end;
            this.diff = initDelta;
            this.source = initSource;
            this.subpopulationId = initSubPopId;
        }

        @Override
        public double getWeight(Feature f) {
            if (this.diff.zeroWeights.contains(f)) {
                return 0.0;
            }
            return CompactCandidateSegmentGroup.this.getSumWeight(this.start, this.end, f) + this.diff.deltaWeight.get(f);
        }

        @Override
        public Iterator<Feature> binaryFeatureIterator() {
            return this.adjust(CompactCandidateSegmentGroup.this.binaryFeatureSet(this.start, this.end, null), this.diff.zeroWeights, null);
        }

        @Override
        public Iterator<Feature> numericFeatureIterator() {
            return this.adjust(CompactCandidateSegmentGroup.this.numericFeatureSet(this.start, this.end, null), this.diff.zeroWeights, this.diff.deltaWeight);
        }

        @Override
        public Iterator<Feature> featureIterator() {
            return this.adjust(CompactCandidateSegmentGroup.this.featureSet(this.start, this.end, null), this.diff.zeroWeights, this.diff.deltaWeight);
        }

        @Override
        public int numFeatures() {
            System.err.println("numFeatures not implemented!");
            return -1;
        }

        private Iterator<Feature> adjust(final Set<Feature> set, THashSet exclude, TObjectDoubleHashMap include) {
            exclude.forEach(new TObjectProcedure(){

                public boolean execute(Object o) {
                    set.remove(o);
                    return true;
                }
            });
            if (include != null) {
                include.forEachKey(new TObjectProcedure(){

                    public boolean execute(Object key) {
                        set.add((Feature)key);
                        return true;
                    }
                });
            }
            return set.iterator();
        }
    }

    private class Delta
    implements Serializable {
        static final long serialVersionUID = 20080207L;
        public TObjectDoubleHashMap deltaWeight = new TObjectDoubleHashMap();
        public THashSet zeroWeights = new THashSet();

        public Delta(FeatureFactory factory, int start, int end, Instance segmentInstance) {
            for (Feature f : CompactCandidateSegmentGroup.this.featureSet(start, end, segmentInstance)) {
                double segmentWeight = segmentInstance.getWeight(f = factory.getFeature(f));
                if (segmentWeight == 0.0) {
                    this.zeroWeights.add(f);
                    continue;
                }
                double sumWeight = CompactCandidateSegmentGroup.this.getSumWeight(start, end, f);
                if (segmentWeight == sumWeight) continue;
                this.deltaWeight.put(f, segmentWeight - sumWeight);
            }
        }
    }
}

