/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.lookup.SoftDictionary;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.transform.AbstractInstanceTransform;
import edu.cmu.minorthird.classify.transform.AugmentedInstance;
import java.io.Serializable;
import java.util.Iterator;

public class DictionaryTransform
extends AbstractInstanceTransform
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SoftDictionary[] softDict;
    private String[] featurePattern;
    private ExampleSchema schema;
    private String[] newFeatureNames;
    private double[] newFeatureValues;
    private StringDistance[][] distances;
    int numDistances;

    public DictionaryTransform(ExampleSchema schema, SoftDictionary[] softDict, String[] featurePattern, StringDistance[][] dists) {
        this.schema = schema;
        this.softDict = softDict;
        this.featurePattern = featurePattern;
        this.distances = dists;
        this.numDistances = this.distances[0].length;
        this.newFeatureNames = new String[schema.getNumberOfClasses() * this.numDistances];
        this.newFeatureValues = new double[this.newFeatureNames.length];
        int r = 0;
        for (int i = 0; i < schema.getNumberOfClasses(); ++i) {
            for (int d = 0; d < this.distances[i].length; ++d) {
                this.newFeatureNames[r++] = this.distances[i][d].toString() + "_" + schema.getClassName(i);
            }
        }
    }

    public Instance transform(Instance instance) {
        int i = 0;
        while (i < this.newFeatureValues.length) {
            this.newFeatureValues[i++] = 0.0;
        }
        String text = DictionaryTransform.getFeatureValue(instance, this.featurePattern);
        if (text == null) {
            return instance;
        }
        boolean nonZeroFeatureAdded = false;
        BasicStringWrapper spanString = new BasicStringWrapper(text);
        for (int i2 = 0; i2 < this.schema.getNumberOfClasses(); ++i2) {
            Object closestMatch = this.softDict[i2].lookup(instance.getSubpopulationId(), spanString);
            if (closestMatch == null) continue;
            for (int d = 0; d < this.distances[i2].length; ++d) {
                double score = this.distances[i2][d].score(spanString, (StringWrapper)closestMatch);
                if (!(score >= 0.0)) continue;
                nonZeroFeatureAdded = true;
                this.newFeatureValues[i2 * this.numDistances + d] = score;
            }
        }
        if (nonZeroFeatureAdded) {
            AugmentedInstance augmentedInstance = new AugmentedInstance(instance, this.newFeatureNames, this.newFeatureValues);
            return augmentedInstance;
        }
        return instance;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[DictionaryTransform: dictSize");
        for (int i = 0; i < this.schema.getNumberOfClasses(); ++i) {
            buf.append(" " + this.schema.getClassName(i) + "=");
            buf.append(Integer.toString(this.softDict[i].size()));
        }
        buf.append("]");
        return buf.toString();
    }

    public static String getFeatureValue(Instance instance, String[] featurePattern) {
        Iterator<Feature> i = instance.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            String[] name = f.getName();
            if (!DictionaryTransform.matches(name, featurePattern)) continue;
            return name[name.length - 1];
        }
        return null;
    }

    private static boolean matches(String[] name, String[] featurePattern) {
        if (name.length - 1 != featurePattern.length) {
            return false;
        }
        for (int i = 0; i < featurePattern.length; ++i) {
            if (featurePattern[i].equals(name[i])) continue;
            return false;
        }
        return true;
    }
}

