/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.MixupAnnotator;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatorLoader {
    private static Logger log = Logger.getLogger(AnnotatorLoader.class);
    private static Properties redirectionProps = new Properties();

    public abstract InputStream findFileResource(String var1);

    public abstract Class<?> findClassResource(String var1);

    public final Annotator findAnnotator(String annotationType, String source) {
        Annotator ann = null;
        log.debug("finding annotator for \"" + annotationType + "\" source=" + source);
        if (source != null) {
            if (source.endsWith(".mixup")) {
                log.debug("non-null mixup");
                InputStream is = this.findFileResource(source);
                if (is != null) {
                    log.debug("loading input stream from found file resource " + source);
                    return this.findMixupAnnotatorFromStream(source, is);
                }
                log.debug("loading input stream directly from file " + source);
                try {
                    is = new FileInputStream(source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return this.findMixupAnnotatorFromStream(source, is);
            }
            log.debug("non-null non-mixup");
            ann = this.findSavedAnnotatorFromStream(source, this.findFileResource(source));
            if (ann == null) {
                ann = this.findNativeAnnotatorFromString(source);
            }
            return ann;
        }
        String redirect = redirectionProps.getProperty(annotationType);
        if (redirect != null) {
            log.debug("redirected to " + redirect);
            return this.findAnnotator(annotationType, redirect);
        }
        InputStream s = this.findFileResource(annotationType + ".mixup");
        if (s != null) {
            log.debug("file resource " + s + " for " + annotationType + ".mixup");
            return this.findMixupAnnotatorFromStream(annotationType + ".mixup", s);
        }
        log.debug("trying as class " + annotationType);
        return this.findNativeAnnotatorFromString(annotationType);
    }

    private final Annotator findSavedAnnotatorFromStream(String annotatorName, InputStream s) {
        log.info("finding saved Annotator " + annotatorName + " in stream " + s);
        if (s != null) {
            try {
                byte[] buf = new byte[s.available()];
                s.read(buf);
                ByteArrayInputStream input = new ByteArrayInputStream(buf);
                ObjectInputStream objInput = new ObjectInputStream(input);
                return (Annotator)objInput.readObject();
            }
            catch (IOException e) {
                log.warn("error loading " + annotatorName + ": " + e);
                return null;
            }
            catch (ClassNotFoundException e) {
                log.warn("annotator " + annotatorName + " not found: " + e);
                return null;
            }
        }
        log.warn("Couldn't find annotator " + annotatorName + " using " + this);
        return null;
    }

    private final Annotator findMixupAnnotatorFromStream(String fileName, InputStream s) {
        log.debug("finding MixupProgram " + fileName + " in stream " + s);
        if (s == null) {
            log.warn("couldn't find mixup program " + fileName + " using " + this);
            return null;
        }
        try {
            byte[] buf = new byte[s.available()];
            s.read(buf);
            MixupProgram p = new MixupProgram(new String(buf));
            return new MixupAnnotator(p);
        }
        catch (Mixup.ParseException e) {
            log.warn("error parsing " + fileName + ": " + e);
            return null;
        }
        catch (IOException e) {
            log.warn("error loading " + fileName + ": " + e);
            return null;
        }
    }

    private final Annotator findNativeAnnotatorFromString(String className) {
        log.debug("looking for native annotator " + className);
        try {
            Class<?> c = this.findClassResource(className);
            Object o = c.newInstance();
            if (o instanceof Annotator) {
                return (Annotator)o;
            }
            log.warn(c + ", found from " + className + " via " + this + ", is not an instance of Annotator");
        }
        catch (Exception e) {
            log.warn(this + " can't find class named " + className + ": " + e);
        }
        return null;
    }

    static {
        InputStream s = ClassLoader.getSystemResourceAsStream("annotators.config");
        if (s == null) {
            try {
                s = new FileInputStream("./config/annotators.config");
            }
            catch (IOException e) {
                log.warn("Can't find annotators.config.");
                log.warn("classpath: " + System.getProperty("java.class.path"));
                log.warn(e);
            }
        } else {
            try {
                redirectionProps.load(s);
            }
            catch (IOException e) {
                log.warn("error trying to load annotators.config: " + e);
            }
        }
    }
}

