/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.BinaryBatchVersion;
import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.DatasetClassifierTeacher;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.algorithms.linear.NaiveBayes;
import edu.cmu.minorthird.classify.algorithms.trees.AdaBoost;
import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.EmptyLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.learn.SampleFE;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;

public class BOWClassifierWrapper {
    private BinaryClassifier classifier;
    private SpanFeatureExtractor fe = SampleFE.BAG_OF_WORDS;

    public BOWClassifierWrapper(File file) throws IOException {
        this.classifier = (BinaryClassifier)IOUtil.loadSerialized(file);
    }

    public BOWClassifierWrapper(InputStream in) throws IOException {
        this.classifier = (BinaryClassifier)IOUtil.loadSerialized(in);
    }

    public double getScore(String string2) {
        BasicTextBase base = new BasicTextBase();
        base.loadDocument("dummyID", string2);
        Span span = base.documentSpan("dummyID");
        Instance instance = this.fe.extractInstance(new EmptyLabels(), span);
        return this.classifier.score(instance);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 2 && "-create".equals(args[0])) {
                BOWClassifierWrapper.testCreateOutput(args[1]);
            } else {
                BOWClassifierWrapper w = new BOWClassifierWrapper(new File(args[0]));
                for (int i = 1; i < args.length; ++i) {
                    System.out.println("score: " + w.getScore(args[i]) + " on input: '" + args[i] + "'");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: -create [file] or [file] testString1 testString2 ...");
        }
    }

    private static void testCreateOutput(String filename) throws IOException {
        System.out.println("loading data and labels");
        BasicTextBase base = new BasicTextBase();
        BasicTextLabels labels = new BasicTextLabels(base);
        new TextLabelsLoader().importOps(labels, base, new File("examples/addChangeDelete.env"));
        System.out.println("learning a test concept");
        SampleFE.AnnotatedSpanFE fe = SampleFE.BAG_OF_WORDS;
        BasicDataset data = new BasicDataset();
        Iterator<Span> i = base.documentSpanIterator();
        while (i.hasNext()) {
            Span s = i.next();
            double label = labels.hasType(s, "delete") ? 1.0 : -1.0;
            EmptyLabels textLabels = new EmptyLabels();
            data.add(new Example(fe.extractInstance(textLabels, s), ClassLabel.binaryLabel(label)));
        }
        AdaBoost learner = new AdaBoost(new BinaryBatchVersion(new NaiveBayes()), 10);
        Classifier c = new DatasetClassifierTeacher(data).train(learner);
        System.out.println("saving it in " + filename);
        IOUtil.saveSerialized((Serializable)((Object)c), new File(filename));
    }
}

