/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SubSpan;
import edu.cmu.minorthird.text.TextToken;
import edu.cmu.minorthird.text.Token;
import edu.cmu.minorthird.text.gui.SpanViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class BasicSpan
implements Span,
Serializable,
Visible {
    private static Logger log = Logger.getLogger(BasicSpan.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final long serialVersionUID = 20080303L;
    private String documentId;
    private String documentGroupId;
    public int loTextTokenIndex;
    public int loCharIndex = -1;
    public int hiCharIndex = -1;
    private int charOffset = 0;
    private int spanLen;
    private TextToken[] textTokens;
    private String text = null;

    public BasicSpan(String documentId, TextToken[] textTokens, int loTextTokenIndex, int spanLen, String documentGroupId) {
        this.documentId = documentId;
        this.textTokens = textTokens;
        this.loTextTokenIndex = loTextTokenIndex;
        this.spanLen = spanLen;
        this.documentGroupId = documentGroupId == null ? documentId : documentGroupId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentGroupId() {
        return this.documentGroupId;
    }

    public String getDocumentContents() {
        if (this.textTokens.length == 0) {
            return "";
        }
        return this.textTokens[0].getDocument();
    }

    public int size() {
        return this.spanLen;
    }

    public TextToken getTextToken(int i) {
        if (i < 0 || i >= this.spanLen) {
            throw new IllegalArgumentException("out of range: " + i);
        }
        return this.textTokens[this.loTextTokenIndex + i];
    }

    public Token getToken(int i) {
        if (i < 0 || i >= this.spanLen) {
            throw new IllegalArgumentException("out of range: " + i);
        }
        return this.textTokens[this.loTextTokenIndex + i];
    }

    public Span subSpan(int start, int len) {
        if (start < 0 || start + len > this.spanLen) {
            throw new IllegalArgumentException("out of range: " + start + "," + len);
        }
        return new BasicSpan(this.documentId, this.textTokens, this.loTextTokenIndex + start, len, this.documentGroupId);
    }

    public SubSpan subSpan(int startIndex, int start, int len) {
        if (start < 0 || start + len > this.spanLen) {
            throw new IllegalArgumentException("out of range: " + start + "," + len);
        }
        return new SubSpan(this.documentId, this.textTokens, this.loTextTokenIndex + start, len, this.documentGroupId, startIndex);
    }

    public Span documentSpan() {
        return new BasicSpan(this.documentId, this.textTokens, 0, this.textTokens.length, this.documentGroupId);
    }

    public int documentSpanStartIndex() {
        return this.loTextTokenIndex;
    }

    public boolean contains(Span other) {
        if (!other.getDocumentId().equals(this.getDocumentId())) {
            return false;
        }
        int myStart = this.documentSpanStartIndex();
        int otherStart = other.documentSpanStartIndex();
        int myEnd = this.documentSpanStartIndex() + this.size();
        int otherEnd = other.documentSpanStartIndex() + other.size();
        return myStart <= otherStart && myEnd >= otherStart && myStart <= otherEnd && myEnd >= otherEnd;
    }

    public boolean overlaps(Span other) {
        if (!other.getDocumentId().equals(this.getDocumentId())) {
            return false;
        }
        int myStart = this.documentSpanStartIndex();
        int otherStart = other.documentSpanStartIndex();
        int myEnd = this.documentSpanStartIndex() + this.size();
        int otherEnd = other.documentSpanStartIndex() + other.size();
        return myStart <= otherStart && myEnd >= otherStart || myStart <= otherEnd && myEnd >= otherEnd || other.contains(this);
    }

    public String asString() {
        if (this.size() <= 0) {
            return "";
        }
        if (this.text == null) {
            TextToken lo = this.getTextToken(0);
            TextToken hi = this.getTextToken(this.size() - 1);
            this.text = lo.getDocument().substring(lo.getLo(), hi.getHi());
        }
        return this.text;
    }

    public Span getLeftBoundary() {
        return new BasicSpan(this.documentId, this.textTokens, this.loTextTokenIndex, 0, this.documentGroupId);
    }

    public Span getRightBoundary() {
        return new BasicSpan(this.documentId, this.textTokens, this.loTextTokenIndex + this.spanLen, 0, this.documentGroupId);
    }

    public int compareTo(Span other) {
        int cmp1 = this.getDocumentId().compareTo(other.getDocumentId());
        if (cmp1 != 0) {
            return cmp1;
        }
        int cmp2 = this.documentSpanStartIndex() - other.documentSpanStartIndex();
        if (cmp2 != 0) {
            return cmp2;
        }
        int cmp3 = this.size() - other.size();
        if (cmp3 != 0) {
            return cmp3;
        }
        return 0;
    }

    public int hashCode() {
        return this.documentId.hashCode() ^ this.loTextTokenIndex ^ this.spanLen;
    }

    public boolean equals(Object o) {
        return o instanceof BasicSpan && this.compareTo((Span)o) == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        buf.append("Span '" + this.asString() + "'");
        buf.append(" = tokens " + this.loTextTokenIndex + ":" + (this.loTextTokenIndex + this.spanLen) + " in ");
        buf.append(this.documentId + "/" + this.documentGroupId);
        return buf.toString();
    }

    public Span charIndexSubSpan(int lo, int hi) {
        return this.charIndexSubSpan(lo, hi, false);
    }

    public Span charIndexProperSubSpan(int lo, int hi) {
        return this.charIndexSubSpan(lo, hi, true);
    }

    public void setCharOffset(int charOffset) {
        this.charOffset = charOffset;
    }

    public int getCharOffset() {
        return this.charOffset;
    }

    private Span charIndexSubSpan(int lo, int hi, boolean proper) {
        this.loCharIndex = lo;
        this.hiCharIndex = hi;
        int minStartDist = Integer.MAX_VALUE;
        int minEndDist = Integer.MAX_VALUE;
        int firstTextToken = -1;
        int lastTextToken = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!proper) {
                if (DEBUG) {
                    log.debug("considering token '" + this.getTextToken(i) + "' from lo=" + this.getTextToken(i).getLo() + " to hi=" + this.getTextToken(i).getHi());
                }
                int startDist = this.distance(this.getTextToken(i).getLo(), lo);
                int endDist = this.distance(this.getTextToken(i).getHi(), hi);
                if (startDist <= minStartDist) {
                    minStartDist = startDist;
                    firstTextToken = i;
                    if (DEBUG) {
                        log.debug("minStartDist => " + minStartDist + " for token " + this.getTextToken(i));
                    }
                }
                if (endDist > minEndDist) continue;
                minEndDist = endDist;
                lastTextToken = i;
                if (!DEBUG) continue;
                log.debug("minEndDist => " + minEndDist + " for token " + this.getTextToken(i));
                continue;
            }
            if (firstTextToken < 0 && lo <= this.getTextToken(i).getHi()) {
                firstTextToken = i;
                if (DEBUG) {
                    log.debug("firstTextToken => " + this.getTextToken(i));
                }
            }
            if (hi <= this.getTextToken(i).getLo()) continue;
            lastTextToken = i;
            if (!DEBUG) continue;
            log.debug("lastTextToken => " + this.getTextToken(i));
        }
        if (firstTextToken < 0 || lastTextToken < 0) {
            throw new IllegalArgumentException("no proper subspan for lo=" + lo + " hi=" + hi + " for: " + this);
        }
        return this.subSpan(this.loCharIndex, firstTextToken, lastTextToken - firstTextToken + 1);
    }

    public int getLoTextToken() {
        return this.loTextTokenIndex;
    }

    public int getLoChar() {
        return this.textTokens[this.loTextTokenIndex].getLo();
    }

    public int getHiChar() {
        return this.textTokens[this.loTextTokenIndex + this.size() - 1].getHi();
    }

    private int distance(int i, int j) {
        return i >= j ? i - j : j - i;
    }

    public Viewer toGUI() {
        return new SpanViewer.ControlledTextViewer(this);
    }
}

