/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.FilterTokenizer;
import edu.cmu.minorthird.text.MutableTextBase;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.Tokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TextBaseManager {
    private Map<String, TextBaseEntry> textBases = new HashMap<String, TextBaseEntry>();
    private Map<String, TextBaseMapper> textBaseMappers = new HashMap<String, TextBaseMapper>();

    public TextBaseManager(TextBase rootBase) {
        this.textBases.put("root", new TextBaseEntry("root", rootBase, 0, null));
    }

    public TextBaseManager(String rootBaseName, TextBase rootBase) {
        this.textBases.put(rootBaseName, new TextBaseEntry(rootBaseName, rootBase, 0, null));
    }

    public boolean containsLevel(String levelName) {
        return this.textBases.containsKey(levelName);
    }

    public TextBase getTextBase(String name) {
        TextBaseEntry entry = this.textBases.get(name);
        return entry.getTextBase();
    }

    private void addTextBase(String parentName, String childName, TextBase childTextBase, TextBaseMapper mapper) {
        TextBaseEntry parentEntry = null;
        if (this.textBases.get(childName) != null) {
            throw new IllegalArgumentException("TextBase already exists with name: " + childName);
        }
        if (parentName != null) {
            parentEntry = this.textBases.get(parentName);
        }
        if (parentEntry != null) {
            int parentLevel = parentEntry.getLevel();
            this.textBases.put(childName, new TextBaseEntry(childName, childTextBase, parentLevel + 1, parentEntry));
            this.textBaseMappers.put(childName, mapper);
        } else {
            this.textBases.put(childName, new TextBaseEntry(childName, childTextBase, 0, null));
            this.textBaseMappers.put(childName, mapper);
        }
    }

    public Span getMatchingSpan(String srcName, String srcDocId, int srcOffset, int length, String dstName) {
        TextBaseEntry srcEntry = this.textBases.get(srcName);
        if (srcEntry == null) {
            throw new IllegalArgumentException("There is no text base named: " + srcName + " in this manager.");
        }
        Span srcDocSpan = srcEntry.getTextBase().documentSpan(srcDocId);
        if (srcDocSpan != null) {
            return this.getMatchingSpan(srcDocSpan.charIndexSubSpan(srcOffset, srcOffset + length), srcName, dstName);
        }
        TextBaseMapper mapper = this.textBaseMappers.get(srcEntry.getName());
        if (mapper == null) {
            return null;
        }
        TextBaseMapper.MapEntry mapping = mapper.getChildMapping(srcDocId, srcOffset, length);
        if (mapping == null) {
            return null;
        }
        String parentDocId = mapping.dstDocId;
        int parentOffset = mapping.dstOffset + (srcOffset - mapping.srcOffset);
        Span parentSpan = srcEntry.getParent().getTextBase().documentSpan(parentDocId).charIndexSubSpan(parentOffset, parentOffset + length);
        return this.getMatchingSpan(parentSpan, srcEntry.getParent().getName(), dstName);
    }

    public Span getMatchingSpan(Span span, String srcName, String dstName) {
        TextBaseEntry srcEntry = this.textBases.get(srcName);
        TextBaseEntry dstEntry = this.textBases.get(dstName);
        if (srcEntry == null) {
            throw new IllegalArgumentException("There is no text base named: " + srcName + " in this manager.");
        }
        if (dstEntry == null) {
            throw new IllegalArgumentException("There is no text base named: " + dstName + " in this manager.");
        }
        if (srcEntry.getTextBase().getDocument(span.getDocumentId()) == null) {
            throw new IllegalArgumentException("The document that the specified span refers to is not in the source text base.");
        }
        ArrayList<TextBaseMapper> srcMapperList = new ArrayList<TextBaseMapper>();
        ArrayList<TextBaseMapper> dstMapperList = new ArrayList<TextBaseMapper>();
        TextBaseEntry currSrcEntry = this.textBases.get(srcName);
        TextBaseEntry currDstEntry = this.textBases.get(dstName);
        while (currSrcEntry.getLevel() != currDstEntry.getLevel()) {
            if (currSrcEntry.getLevel() > currDstEntry.getLevel()) {
                srcMapperList.add(this.textBaseMappers.get(currSrcEntry.getName()));
                currSrcEntry = currSrcEntry.getParent();
                continue;
            }
            dstMapperList.add(this.textBaseMappers.get(currDstEntry.getName()));
            currDstEntry = currDstEntry.getParent();
        }
        while (currSrcEntry != currDstEntry) {
            srcMapperList.add(this.textBaseMappers.get(currSrcEntry.getName()));
            currSrcEntry = currSrcEntry.getParent();
            dstMapperList.add(this.textBaseMappers.get(currDstEntry.getName()));
            currDstEntry = currDstEntry.getParent();
        }
        Span matchingSpan = span;
        for (TextBaseMapper currMapper : srcMapperList) {
            matchingSpan = currMapper.getMappedParentSpan(matchingSpan);
            if (matchingSpan != null) continue;
            return null;
        }
        for (TextBaseMapper currMapper : dstMapperList) {
            matchingSpan = currMapper.getMappedChildSpan(matchingSpan);
            if (matchingSpan != null) continue;
            return null;
        }
        return matchingSpan;
    }

    public MutableTextBase retokenize(Tokenizer newTokenizer, String parentLevelName, String newLevelName) {
        TextBaseEntry parentEntry = this.textBases.get(parentLevelName);
        if (parentEntry == null) {
            throw new IllegalArgumentException("There is no text base named: " + parentLevelName + " in this manager.");
        }
        BasicTextBase newTextBase = new BasicTextBase(newTokenizer);
        TextBaseMapper newMapper = new TextBaseMapper(parentEntry.getTextBase(), newTextBase);
        this.addTextBase(parentLevelName, newLevelName, newTextBase, newMapper);
        Iterator<Span> docsLooper = this.textBases.get(parentLevelName).getTextBase().documentSpanIterator();
        while (docsLooper.hasNext()) {
            Span currDocSpan = docsLooper.next();
            newTextBase.loadDocument(currDocSpan.getDocumentId(), currDocSpan.getDocumentContents());
            newMapper.mapPlace(currDocSpan.getDocumentId(), 0, currDocSpan.getDocumentId(), 0);
        }
        return newTextBase;
    }

    public TextBase filter(String parentLevelName, TextLabels parentLabels, String newLevelName, String spanType) {
        BasicTextBase newTextBase = new BasicTextBase(new FilterTokenizer(this, newLevelName, parentLevelName));
        TextBaseMapper newMapper = new TextBaseMapper(parentLabels.getTextBase(), newTextBase);
        this.addTextBase(parentLevelName, newLevelName, newTextBase, newMapper);
        Iterator<Span> typeInstances = parentLabels.instanceIterator(spanType);
        String prevDocId = "";
        int docNum = 0;
        while (typeInstances.hasNext()) {
            Span currInstance = typeInstances.next();
            String curDocId = currInstance.getDocumentId();
            docNum = curDocId.equals(prevDocId) ? ++docNum : 0;
            String newDocID = "childTB" + docNum + "-" + curDocId;
            newMapper.mapPlace(curDocId, currInstance.getLoChar(), newDocID, 0);
            prevDocId = curDocId;
            String newDocText = currInstance.asString();
            int startIndex = currInstance.getLoChar();
            newTextBase.loadDocument(newDocID, newDocText, startIndex);
        }
        return newTextBase;
    }

    private class TextBaseMapper {
        private TextBase parent;
        private TextBase child;
        private Map<String, SortedSet<MapEntry>> parentToChildMap;
        private Map<String, SortedSet<MapEntry>> childToParentMap;

        public TextBaseMapper(TextBase parent, TextBase child) {
            this.parent = parent;
            this.child = child;
            this.parentToChildMap = new HashMap<String, SortedSet<MapEntry>>();
            this.childToParentMap = new HashMap<String, SortedSet<MapEntry>>();
        }

        public void mapPlace(String parentDocId, int parentOffset, String childDocId, int childOffset) {
            SortedSet<MapEntry> parentEntry = this.parentToChildMap.get(parentDocId);
            if (parentEntry == null) {
                parentEntry = new TreeSet<MapEntry>();
                this.parentToChildMap.put(parentDocId, parentEntry);
            }
            parentEntry.add(new MapEntry(parentDocId, parentOffset, childDocId, childOffset));
            SortedSet<MapEntry> childEntry = this.childToParentMap.get(childDocId);
            if (childEntry == null) {
                childEntry = new TreeSet<MapEntry>();
                this.childToParentMap.put(childDocId, childEntry);
            }
            childEntry.add(new MapEntry(childDocId, childOffset, parentDocId, parentOffset));
        }

        public MapEntry getParentMapping(String parentDocId, int parentOffset, int length) {
            SortedSet<MapEntry> parentDocMap = this.parentToChildMap.get(parentDocId);
            if (parentDocMap == null) {
                throw new IllegalArgumentException("Document containing parent char sequence has no mappings.");
            }
            Iterator it = parentDocMap.iterator();
            MapEntry curr = null;
            MapEntry parentEntry = null;
            while (it.hasNext()) {
                curr = (MapEntry)it.next();
                if (curr.srcOffset <= parentOffset) {
                    parentEntry = curr;
                    continue;
                }
                if (curr.srcOffset >= parentOffset + length) continue;
                return null;
            }
            return parentEntry;
        }

        public MapEntry getChildMapping(String childDocId, int childOffset, int length) {
            SortedSet<MapEntry> childDocMap = this.childToParentMap.get(childDocId);
            if (childDocMap == null) {
                throw new IllegalArgumentException("Document containing child char sequence has no mappings.");
            }
            Iterator it = childDocMap.iterator();
            MapEntry curr = null;
            MapEntry childEntry = null;
            while (it.hasNext()) {
                curr = (MapEntry)it.next();
                if (curr.srcOffset <= childOffset) {
                    childEntry = curr;
                    continue;
                }
                if (curr.srcOffset >= childOffset + length) continue;
                return null;
            }
            return childEntry;
        }

        public Span getMappedChildSpan(Span parentSpan) {
            if (this.parent.getDocument(parentSpan.getDocumentId()) == null) {
                throw new IllegalArgumentException("Document containing parent span not in the child text base of this mapper.");
            }
            int parentLo = parentSpan.getTextToken(0).getLo();
            int parentHi = parentSpan.getTextToken(parentSpan.size() - 1).getHi();
            MapEntry parentEntry = this.getParentMapping(parentSpan.getDocumentId(), parentLo, parentHi - parentLo);
            if (parentEntry == null) {
                return null;
            }
            return this.child.documentSpan(parentEntry.dstDocId).charIndexSubSpan(parentEntry.dstOffset + (parentLo - parentEntry.srcOffset), parentEntry.dstOffset + (parentHi - parentEntry.srcOffset));
        }

        public Span getMappedParentSpan(Span childSpan) {
            if (this.child.getDocument(childSpan.getDocumentId()) == null) {
                throw new IllegalArgumentException("Document containing child span not in the parent text base of this mapper.");
            }
            int childLo = childSpan.getTextToken(0).getLo();
            int childHi = childSpan.getTextToken(childSpan.size() - 1).getHi();
            MapEntry childEntry = this.getChildMapping(childSpan.getDocumentId(), childLo, childHi - childLo);
            if (childEntry == null) {
                return null;
            }
            return this.parent.documentSpan(childEntry.dstDocId).charIndexSubSpan(childEntry.dstOffset + (childLo - childEntry.srcOffset), childEntry.dstOffset + (childHi - childEntry.srcOffset));
        }

        public void printMap() {
            Iterator mappingsIterator;
            SortedSet<MapEntry> currDocMapings;
            System.out.println("****************************************************");
            System.out.println("*** Mapper Between Parent: " + this.parent + " and Child: " + this.child + " ***");
            System.out.println("***                                              ***");
            System.out.println("*** Parent To Child mappings:                    ***");
            for (String currKey : this.parentToChildMap.keySet()) {
                currDocMapings = this.parentToChildMap.get(currKey);
                mappingsIterator = currDocMapings.iterator();
                while (mappingsIterator.hasNext()) {
                    System.out.println("*** " + mappingsIterator.next() + " ***");
                }
            }
            System.out.println("***                                              ***");
            System.out.println("*** Child To Parent mappings:                    ***");
            for (String currKey : this.childToParentMap.keySet()) {
                currDocMapings = this.childToParentMap.get(currKey);
                mappingsIterator = currDocMapings.iterator();
                while (mappingsIterator.hasNext()) {
                    System.out.println("*** " + mappingsIterator.next() + " ***");
                }
            }
            System.out.println("****************************************************\n\n");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MapEntry
        implements Comparable<MapEntry> {
            public String srcDocId;
            public int srcOffset;
            public String dstDocId;
            public int dstOffset;

            public MapEntry(String sid, int sos, String did, int dos) {
                this.srcDocId = sid;
                this.srcOffset = sos;
                this.dstDocId = did;
                this.dstOffset = dos;
            }

            @Override
            public int compareTo(MapEntry o) {
                int res = this.srcDocId.compareTo(o.srcDocId);
                if (res == 0) {
                    res = this.srcOffset - o.srcOffset;
                }
                return res;
            }

            public String toString() {
                return this.srcDocId + ":" + this.srcOffset + " -> " + this.dstDocId + ":" + this.dstOffset;
            }
        }
    }

    private class TextBaseEntry {
        private String entryName;
        private TextBase textBase;
        private TextBaseEntry parent;
        private int level;

        public TextBaseEntry(String newEntryName, TextBase newTextBase, int newLevel, TextBaseEntry newParent) {
            this.entryName = newEntryName;
            this.textBase = newTextBase;
            this.level = newLevel;
            this.parent = newParent;
        }

        public String getName() {
            return this.entryName;
        }

        public TextBase getTextBase() {
            return this.textBase;
        }

        public int getLevel() {
            return this.level;
        }

        public TextBaseEntry getParent() {
            return this.parent;
        }
    }
}

