/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLAnnotator
extends AbstractAnnotator {
    static final Pattern URL_CANDIDATE = Pattern.compile("\\b(\\w+:)?/[/\\w;:\\@\\$\\-~#%\\?\\&\\+=\\.]+");
    static final String URL_SPANTYPE = "URL";
    static final String URL_ANNOTATION_TYPE = "URL";

    protected void doAnnotate(MonotonicTextLabels labels) {
        Iterator<Span> i = labels.getTextBase().documentSpanIterator();
        while (i.hasNext()) {
            Span docSpan = i.next();
            String docString = docSpan.getDocumentContents();
            Matcher m = URL_CANDIDATE.matcher(docString);
            while (m.find()) {
                int hi;
                int lo = m.start();
                if (!this.validURL(docString.substring(lo, hi = m.end()))) continue;
                labels.addToType(docSpan.charIndexSubSpan(lo, hi), "URL");
            }
        }
        labels.setAnnotatedBy("URL");
    }

    private boolean validURL(String s) {
        try {
            new URL(s);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        return "no explanation available";
    }
}

