/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.HiliteColors;
import edu.cmu.minorthird.text.gui.SpanPainter;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.ViewerTracker;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;

public class SpanEditor
extends ViewerTracker {
    static final long serialVersionUID = 200803014L;
    public static final String EDITOR_PROP = "_edited";
    private String importType;
    private String exportType;
    private JLabel ioTypeLabel;
    private SortedSet<Span> editedSpans;
    private int editSpanCursor = -1;
    private boolean readOnly = false;
    JButton readOnlyButton = new JButton(new ReadOnlyButton(this.readOnly ? "Edit" : "Read"));
    JButton importButton = new JButton(new ImportGuessSpans("Import"));
    JButton exportButton = new JButton(new ExportGuessSpans("Export"));
    JButton addButton = new JButton(new AddSelection("Add"));
    JButton deleteButton = new JButton(new DeleteCursoredSpan("Delete"));
    JButton propButton = new JButton(new EditSpanProperties("Props"));
    JButton prevButton = new JButton(new MoveSpanCursor("Prev", -1));
    JButton nextButton = new JButton(new MoveSpanCursor("Next", 1));
    private List<JButton> buttonsThatChangeStuff = new ArrayList<JButton>();

    public SpanEditor(TextLabels viewLabels, MutableTextLabels editLabels, JList documentList, SpanPainter spanPainter, StatusMessage statusMsg) {
        super(viewLabels, editLabels, documentList, spanPainter, statusMsg);
        this.init();
    }

    private void init() {
        this.exportType = null;
        this.importType = null;
        this.ioTypeLabel = new JLabel("Types: [None/None]");
        this.initLayout();
        this.loadSpan(this.nullSpan());
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        int col = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        ++col;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.ioTypeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.readOnlyButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.buttonsThatChangeStuff.add(this.importButton);
        this.add((Component)this.importButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.buttonsThatChangeStuff.add(this.exportButton);
        this.add((Component)this.exportButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.buttonsThatChangeStuff.add(this.addButton);
        this.add((Component)this.addButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.buttonsThatChangeStuff.add(this.deleteButton);
        this.add((Component)this.deleteButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.buttonsThatChangeStuff.add(this.propButton);
        this.add((Component)this.propButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.prevButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.nextButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.upButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.downButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.contextWidthSlider, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = 2;
        this.add((Component)this.saveButton, gbc);
        this.buttonsThatChangeStuff.add(this.saveButton);
        this.saveButton.setEnabled(this.saveAsFile != null);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = col;
        this.add((Component)this.editorHolder, gbc);
    }

    public void setReadOnly(boolean readOnly) {
        for (JButton button : this.buttonsThatChangeStuff) {
            button.setEnabled(!readOnly);
        }
        this.readOnly = readOnly;
    }

    public void setTypesBeingEdited(String inType, String outType) {
        this.importType = inType;
        this.exportType = outType;
        this.ioTypeLabel.setText("Edit: " + this.importType + "/" + this.exportType);
    }

    protected void loadSpanHook() {
        if (this.readOnly && !"***dummy id***".equals(this.documentSpan.getDocumentId())) {
            this.importDocumentListMarkup(this.documentSpan.getDocumentId());
        }
        Keymap keymap = JTextComponent.getKeymap("default");
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control I"), this.importButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control E"), this.exportButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control S"), this.exportButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control A"), this.addButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("DELETE"), this.deleteButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control D"), this.deleteButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("LEFT"), this.prevButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control B"), this.prevButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("RIGHT"), this.nextButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control F"), this.nextButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("TAB"), this.nextButton.getAction());
        this.editedSpans = new TreeSet<Span>();
    }

    private Span getEditSpan(int k) {
        for (Span s : this.editedSpans) {
            if (k-- != 0) continue;
            return s;
        }
        throw new IllegalStateException("bad editedSpan index " + k);
    }

    private class MoveSpanCursor
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;
        private int delta;

        public MoveSpanCursor(String msg, int delta) {
            super(msg);
            this.delta = delta;
        }

        public void actionPerformed(ActionEvent event) {
            if (SpanEditor.this.editedSpans == null || SpanEditor.this.editedSpans.isEmpty()) {
                return;
            }
            if (SpanEditor.this.editSpanCursor >= 0) {
                SpanEditor.this.editedDoc.highlight(SpanEditor.this.getEditSpan(SpanEditor.this.editSpanCursor), HiliteColors.yellow);
                SpanEditor.this.editSpanCursor = SpanEditor.this.editSpanCursor + this.delta;
                if (SpanEditor.this.editSpanCursor < 0) {
                    SpanEditor.this.editSpanCursor += SpanEditor.this.editedSpans.size();
                } else if (SpanEditor.this.editSpanCursor >= SpanEditor.this.editedSpans.size()) {
                    SpanEditor.this.editSpanCursor -= SpanEditor.this.editedSpans.size();
                }
            } else {
                SpanEditor.this.editSpanCursor = 0;
            }
            SpanEditor.this.editedDoc.highlight(SpanEditor.this.getEditSpan(SpanEditor.this.editSpanCursor), HiliteColors.cursorColor);
            SpanEditor.this.statusMsg.display("to span#" + SpanEditor.this.editSpanCursor + ": " + SpanEditor.this.getEditSpan(SpanEditor.this.editSpanCursor));
        }
    }

    private class SpanPropertyViewer
    extends ComponentViewer {
        static final long serialVersionUID = 200803014L;

        private SpanPropertyViewer() {
        }

        public JComponent componentFor(Object o) {
            final Span span = (Span)o;
            final JTabbedPane pane = new JTabbedPane();
            final JTextField propField = new JTextField(10);
            final JTextField valField = new JTextField(10);
            JTable table = this.makePropertyTable(span);
            final JScrollPane tableScroller = new JScrollPane(table);
            JButton addButton = new JButton(new AbstractAction("Insert Property"){
                static final long serialVersionUID = 200803014L;

                public void actionPerformed(ActionEvent event) {
                    SpanEditor.this.editLabels.setProperty(span, propField.getText(), valField.getText());
                    tableScroller.getViewport().setView(SpanPropertyViewer.this.makePropertyTable(span));
                    tableScroller.revalidate();
                    pane.revalidate();
                }
            });
            GridBagConstraints gbc = SpanPropertyViewer.fillerGBC();
            gbc.gridwidth = 3;
            JPanel subpanel = new JPanel();
            subpanel.setLayout(new GridBagLayout());
            subpanel.add((Component)tableScroller, gbc);
            subpanel.add((Component)addButton, this.myGBC(0));
            subpanel.add((Component)propField, this.myGBC(1));
            subpanel.add((Component)valField, this.myGBC(2));
            pane.add("Properties", subpanel);
            pane.add("Span", new SmartVanillaViewer(span));
            return pane;
        }

        private GridBagConstraints myGBC(int col) {
            GridBagConstraints gbc = SpanPropertyViewer.fillerGBC();
            gbc.fill = 2;
            gbc.gridx = col;
            gbc.gridy = 1;
            return gbc;
        }

        private JTable makePropertyTable(Span span) {
            Object[] spanProps = SpanEditor.this.editLabels.getSpanProperties().toArray();
            Object[][] table = new Object[spanProps.length][2];
            for (int i = 0; i < spanProps.length; ++i) {
                table[i][0] = spanProps[i];
                table[i][1] = SpanEditor.this.editLabels.getProperty(span, (String)spanProps[i]);
            }
            Object[] colNames = new String[]{"Property", "Property's Value"};
            return new JTable(table, colNames);
        }
    }

    private class EditSpanProperties
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public EditSpanProperties(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            Span span = null;
            if (SpanEditor.this.editSpanCursor >= 0) {
                span = SpanEditor.this.getEditSpan(SpanEditor.this.editSpanCursor);
            } else {
                int lo = SpanEditor.this.editorPane.getSelectionStart();
                int hi = SpanEditor.this.editorPane.getSelectionEnd();
                span = SpanEditor.this.documentSpan.charIndexSubSpan(lo, hi);
            }
            SpanPropertyViewer viewer = new SpanPropertyViewer();
            viewer.setContent(span);
            new ViewerFrame("Span to edit", viewer);
        }
    }

    private class DeleteCursoredSpan
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public DeleteCursoredSpan(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            Span span = null;
            if (SpanEditor.this.editSpanCursor >= 0) {
                span = SpanEditor.this.getEditSpan(SpanEditor.this.editSpanCursor);
            } else {
                int lo = SpanEditor.this.editorPane.getSelectionStart();
                int hi = SpanEditor.this.editorPane.getSelectionEnd();
                span = SpanEditor.this.documentSpan.charIndexSubSpan(lo, hi);
            }
            SpanEditor.this.editedDoc.highlight(span, SimpleAttributeSet.EMPTY);
            SpanEditor.this.editedSpans.remove(span);
            if (SpanEditor.this.editSpanCursor >= SpanEditor.this.editedSpans.size()) {
                SpanEditor.this.editSpanCursor = -1;
            } else if (SpanEditor.this.editSpanCursor >= 0) {
                SpanEditor.this.editedDoc.highlight(SpanEditor.this.getEditSpan(SpanEditor.this.editSpanCursor), HiliteColors.cursorColor);
            }
        }
    }

    private class AddSelection
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public AddSelection(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            int lo = SpanEditor.this.editorPane.getSelectionStart();
            int hi = SpanEditor.this.editorPane.getSelectionEnd();
            lo = SpanEditor.this.editedDoc.toLogicalCharIndex(lo);
            hi = SpanEditor.this.editedDoc.toLogicalCharIndex(hi);
            Span span = SpanEditor.this.documentSpan.charIndexSubSpan(lo, hi);
            int correction = 0;
            if (SpanEditor.this.editSpanCursor >= 0 && span.compareTo(SpanEditor.this.getEditSpan(SpanEditor.this.editSpanCursor)) < 0) {
                correction = 1;
            }
            SpanEditor.this.editedDoc.highlight(span, HiliteColors.yellow);
            SpanEditor.this.editedSpans.add(span);
            SpanEditor.this.editSpanCursor += correction;
            SpanEditor.this.statusMsg.display("adding " + span);
        }
    }

    private class ExportGuessSpans
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public ExportGuessSpans(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            if (SpanEditor.this.exportType == null) {
                SpanEditor.this.statusMsg.display("what type?");
                return;
            }
            Iterator<Span> newSpans = SpanEditor.this.editedSpans.iterator();
            SpanEditor.this.editLabels.defineTypeInside(SpanEditor.this.exportType, SpanEditor.this.documentSpan, newSpans);
            SpanEditor.this.spanPainter.paintDocument(SpanEditor.this.documentSpan.getDocumentId());
            SpanEditor.this.editSpanCursor = -1;
            SpanEditor.this.statusMsg.display("exported " + SpanEditor.this.editedSpans.size() + " " + SpanEditor.this.exportType + " spans");
        }
    }

    private class ImportGuessSpans
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public ImportGuessSpans(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            if (SpanEditor.this.importType == null) {
                SpanEditor.this.statusMsg.display("what type?");
                return;
            }
            SpanEditor.this.editedDoc.resetHighlights();
            SpanEditor.this.editedSpans = new TreeSet();
            Iterator<Span> i = SpanEditor.this.viewLabels.instanceIterator(SpanEditor.this.importType, SpanEditor.this.documentSpan.getDocumentId());
            while (i.hasNext()) {
                Span guessSpan = i.next();
                SpanEditor.this.editedDoc.highlight(guessSpan, HiliteColors.yellow);
                SpanEditor.this.editedSpans.add(guessSpan);
            }
            SpanEditor.this.editSpanCursor = -1;
            SpanEditor.this.statusMsg.display("imported " + SpanEditor.this.editedSpans.size() + " " + SpanEditor.this.importType + " spans to " + SpanEditor.this.documentSpan.getDocumentId());
        }
    }

    private class ReadOnlyButton
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public ReadOnlyButton(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            SpanEditor.this.setReadOnly(!SpanEditor.this.readOnly);
            if (SpanEditor.this.documentSpan != null) {
                SpanEditor.this.loadSpan(SpanEditor.this.documentSpan);
            }
            SpanEditor.this.readOnlyButton.setText(SpanEditor.this.readOnly ? "Edit" : "Read");
        }
    }
}

