/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.StatusMessagePanel;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.gui.ViewerTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;

public class TrackedTextBaseComponent
extends JComponent {
    static final long serialVersionUID = 20080314L;
    protected Logger log;
    protected TextBase base;
    protected TextLabels viewLabels;
    protected MutableTextLabels editLabels;
    protected StatusMessage statusMsg;
    protected TextBaseViewer viewer;
    protected ViewerTracker viewerTracker;
    private boolean laidOut = false;

    protected TrackedTextBaseComponent() {
        this.log = Logger.getLogger(this.getClass().getName());
    }

    public TrackedTextBaseComponent(TextBase base, TextLabels viewLabels, MutableTextLabels editLabels, StatusMessage statusMsg) {
        this.init(base, viewLabels, editLabels, statusMsg);
    }

    protected void init(TextBase base, TextLabels viewLabels, MutableTextLabels editLabels, StatusMessage statusMsg) {
        this.log = Logger.getLogger(this.getClass().getName());
        this.base = base;
        this.viewLabels = viewLabels;
        this.editLabels = editLabels;
        this.statusMsg = statusMsg;
    }

    public TextBaseViewer getViewer() {
        return this.viewer;
    }

    public ViewerTracker getViewerTracker() {
        return this.viewerTracker;
    }

    protected void initializeLayout() {
        if (this.laidOut) {
            return;
        }
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new GridBagLayout());
        this.viewer.setMinimumSize(new Dimension(200, 200));
        this.viewerTracker.setMinimumSize(new Dimension(200, 50));
        JSplitPane splitPane = new JSplitPane(0, this.viewer, this.viewerTracker);
        splitPane.setDividerLocation(400);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)splitPane, gbc);
        this.laidOut = true;
    }

    public void updateTextLabels(TextLabels newLabels) {
        this.viewLabels = newLabels;
        this.viewer.updateTextLabels(newLabels);
        this.viewerTracker.updateViewLabels(newLabels);
    }

    public void setSaveAs(File file) {
        this.viewerTracker.setSaveAs(file);
    }

    protected void buildFrame() {
        StatusMessagePanel main = new StatusMessagePanel(this, this.statusMsg);
        JFrame frame = new JFrame(this.getClass().getName());
        frame.getContentPane().add((Component)main, "Center");
        frame.addWindowListener(new WindowAdapter(){});
        frame.pack();
        frame.setVisible(true);
    }
}

