/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.Token;
import edu.cmu.minorthird.text.learn.AnnotationExample;
import edu.cmu.minorthird.text.learn.AnnotatorLearner;
import edu.cmu.minorthird.text.learn.Extraction2TaggingReduction;
import edu.cmu.minorthird.text.learn.InsideOutsideReduction;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.ui.Recommended;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBatchAnnotatorLearner
extends AnnotatorLearner {
    private static Logger log = Logger.getLogger(AbstractBatchAnnotatorLearner.class);
    protected SpanFeatureExtractor fe;
    protected String annotationType = "_prediction";
    protected SequenceDataset seqData;
    protected Extraction2TaggingReduction reduction;
    private Iterator<Span> documentLooper;

    public AbstractBatchAnnotatorLearner() {
        this(new Recommended.TokenFE(), new InsideOutsideReduction());
    }

    public AbstractBatchAnnotatorLearner(SpanFeatureExtractor fe, Extraction2TaggingReduction reduction) {
        this.reduction = reduction;
        this.fe = fe;
        this.seqData = new SequenceDataset();
    }

    @Override
    public void reset() {
        this.seqData = new SequenceDataset();
    }

    public Extraction2TaggingReduction getTaggingReduction() {
        return this.reduction;
    }

    public void setTaggingReduction(Extraction2TaggingReduction reduction) {
        this.reduction = reduction;
    }

    public String getTaggingReductionHelp() {
        return "Scheme for reducing extraction to a token-classification problem";
    }

    @Override
    public SpanFeatureExtractor getSpanFeatureExtractor() {
        return this.fe;
    }

    @Override
    public void setSpanFeatureExtractor(SpanFeatureExtractor fe) {
        this.fe = fe;
    }

    @Override
    public void setAnnotationType(String s) {
        this.annotationType = s;
    }

    @Override
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public void setDocumentPool(Iterator<Span> documentLooper) {
        this.documentLooper = documentLooper;
    }

    @Override
    public boolean hasNextQuery() {
        return this.documentLooper.hasNext();
    }

    @Override
    public Span nextQuery() {
        return this.documentLooper.next();
    }

    @Override
    public void setAnswer(AnnotationExample answeredQuery) {
        this.reduction.reduceExtraction2Tagging(answeredQuery);
        TextLabels answerLabels = this.reduction.getTaggedLabels();
        Span document = answeredQuery.getDocumentSpan();
        Example[] sequence = new Example[document.size()];
        for (int i = 0; i < document.size(); ++i) {
            Example example;
            Token tok = document.getToken(i);
            String value = answerLabels.getProperty(tok, this.reduction.getTokenProp());
            if (value == null) {
                log.warn("ignoring " + document.getDocumentId() + " because token " + i + " not labeled in " + document);
                return;
            }
            ClassLabel classLabel = new ClassLabel(value);
            Span tokenSpan = document.subSpan(i, 1);
            sequence[i] = example = new Example(this.fe.extractInstance(answeredQuery.getLabels(), tokenSpan), classLabel);
        }
        this.seqData.addSequence(sequence);
    }

    @Override
    public abstract Annotator getAnnotator();

    public SequenceDataset getSequenceDataset() {
        return this.seqData;
    }
}

