/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.EmptyLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.text.learn.TextClassifier;

public class BinaryTextClassifier
implements TextClassifier {
    private OnlineClassifierLearner learner;
    private SpanFeatureExtractor fe = null;
    private int docNum;
    private static final String DOC = "OnlineDocument_";

    public BinaryTextClassifier(OnlineClassifierLearner learner, SpanFeatureExtractor fe) {
        this.learner = learner;
        this.fe = fe;
        this.docNum = 0;
    }

    public double score(String text) {
        BasicTextBase tb = new BasicTextBase();
        ++this.docNum;
        String docID = DOC + this.docNum;
        tb.loadDocument(docID, text);
        Span docSpan = tb.documentSpan(docID);
        EmptyLabels textLabels = new EmptyLabels();
        Instance i = this.fe.extractInstance(textLabels, docSpan);
        Classifier c = this.learner.getClassifier();
        if (!(c instanceof BinaryClassifier)) {
            throw new IllegalArgumentException("The classifier must be binary");
        }
        double score = ((BinaryClassifier)c).score(i);
        return score;
    }
}

