/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.learn.ExtractorAnnotator;
import edu.cmu.minorthird.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ExtractorAnnotatorWrapper {
    private ExtractorAnnotator annotator;

    public ExtractorAnnotatorWrapper(File file) throws IOException {
        this.annotator = (ExtractorAnnotator)((Object)IOUtil.loadSerialized(file));
    }

    public ExtractorAnnotatorWrapper(InputStream stream) throws IOException {
        this.annotator = (ExtractorAnnotator)((Object)IOUtil.loadSerialized(stream));
    }

    public ExtractorAnnotatorWrapper(ExtractorAnnotator annotator) {
        this.annotator = annotator;
    }

    public ExtractorAnnotator getAnnotator() {
        return this.annotator;
    }

    public String[] extractFrom(String source) {
        BasicTextBase base = new BasicTextBase();
        base.loadDocument("noSource", source);
        BasicTextLabels labels = new BasicTextLabels(base);
        this.annotator.annotate(labels);
        ArrayList<String> accum = new ArrayList<String>();
        Iterator<Span> i = labels.instanceIterator(this.annotator.getSpanType());
        while (i.hasNext()) {
            Span s = i.next();
            accum.add(s.asString());
        }
        return accum.toArray(new String[accum.size()]);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: annotator-file sample-string1 sample-string2 ...");
        } else {
            ExtractorAnnotatorWrapper w = new ExtractorAnnotatorWrapper(new File(args[0]));
            for (int i = 1; i < args.length; ++i) {
                String[] result = w.extractFrom(args[i]);
                System.out.println("Total of " + result.length + " extractions from arg" + i + ":");
                for (int j = 0; j < result.length; ++j) {
                    System.out.println("\t'" + result[j] + "'");
                }
            }
        }
    }
}

