/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.text.AbstractSpanFinder;
import edu.cmu.minorthird.text.Details;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanFinder;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredFinder
extends AbstractSpanFinder
implements Serializable {
    private static final long serialVersionUID = 20080306L;
    private BinaryClassifier spanFilter;
    private SpanFeatureExtractor fe;
    private SpanFinder candidateFinder;
    private SortedMap<Span, Details> detailMap;

    public FilteredFinder(BinaryClassifier spanFilter, SpanFeatureExtractor fe, SpanFinder candidateFinder) {
        this.spanFilter = spanFilter;
        this.fe = fe;
        this.candidateFinder = candidateFinder;
        this.detailMap = new TreeMap<Span, Details>();
    }

    @Override
    public Iterator<Span> findSpans(TextLabels labels, Span documentSpan) {
        this.detailMap.clear();
        Iterator<Span> i = this.candidateFinder.findSpans(labels, documentSpan);
        while (i.hasNext()) {
            Span candidate = i.next();
            double prediction = this.spanFilter.score(this.fe.extractInstance(labels, candidate));
            if (!(prediction > 0.0)) continue;
            this.detailMap.put(candidate, new Details(prediction));
        }
        return this.detailMap.keySet().iterator();
    }

    @Override
    public Details getDetails(Span s) {
        return (Details)this.detailMap.get(s);
    }

    public String toString() {
        return "[FilteredFinder " + this.spanFilter + "]";
    }

    @Override
    public String explainFindSpans(TextLabels labels, Span documentSpan) {
        StringBuffer buf = new StringBuffer("");
        buf.append("Explaining findSpans for " + documentSpan + ":\n");
        Iterator<Span> i = this.candidateFinder.findSpans(labels, documentSpan);
        while (i.hasNext()) {
            Span candidate = i.next();
            buf.append("candidate: " + candidate + "\n");
            Instance instance = this.fe.extractInstance(labels, candidate);
            buf.append("instance: " + instance + "\n");
            buf.append("classification: " + this.spanFilter.explain(instance) + "\n");
            buf.append("\n");
        }
        return buf.toString();
    }
}

