/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.EmptyLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.SpanFE;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public class SampleFE {
    public static final AnnotatedSpanFE BAG_OF_WORDS = new BagOfWordsFE();
    public static final AnnotatedSpanFE BAG_OF_LC_WORDS = new BagOfLowerCaseWordsFE();

    public static final AnnotatedSpanFE makeExtractionFE(int featureWindowSize) {
        ExtractionFE fe = new ExtractionFE();
        fe.setFeatureWindowSize(featureWindowSize);
        return fe;
    }

    public static void main(String[] args) {
        try {
            int i;
            AnnotatedSpanFE fe = BAG_OF_LC_WORDS;
            BasicTextBase base = new BasicTextBase();
            for (i = 0; i < SampleDatasets.posTrain.length; ++i) {
                base.loadDocument("pos" + i, SampleDatasets.posTrain[i]);
            }
            for (i = 0; i < SampleDatasets.negTrain.length; ++i) {
                base.loadDocument("neg" + i, SampleDatasets.negTrain[i]);
            }
            BasicDataset dataset = new BasicDataset();
            Iterator<Span> i2 = base.documentSpanIterator();
            while (i2.hasNext()) {
                Span s = i2.next();
                String id = s.getDocumentId();
                ClassLabel label = ClassLabel.binaryLabel(id.startsWith("pos") ? 1.0 : -1.0);
                EmptyLabels textLabels = new EmptyLabels();
                dataset.add(new Example(fe.extractInstance(textLabels, s), label));
            }
            new ViewerFrame("Toy data", dataset.toGUI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static abstract class AnnotatedSpanFE
    extends SpanFE {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtractionFE
    extends AnnotatedSpanFE {
        static final long serialVersionUID = 20080306L;
        protected int windowSize = 5;
        protected boolean useCharType = true;
        protected boolean useCompressedCharType = true;
        protected String[] tokenPropertyFeatures = new String[0];

        public ExtractionFE() {
            this(3);
        }

        public ExtractionFE(int windowSize) {
            this.windowSize = windowSize;
        }

        public void setFeatureWindowSize(int n) {
            this.windowSize = n;
        }

        public int getFeatureWindowSize() {
            return this.windowSize;
        }

        public void setUseCharType(boolean flag) {
            this.useCharType = flag;
        }

        public boolean getUseCharType() {
            return this.useCharType;
        }

        public void setUseCompressedCharType(boolean flag) {
            this.useCompressedCharType = flag;
        }

        public boolean getUseCompressedCharType() {
            return this.useCompressedCharType;
        }

        public void setTokenPropertyFeatures(String commaSeparatedTokenPropertyList) {
            this.tokenPropertyFeatures = "*".equals(commaSeparatedTokenPropertyList) ? null : commaSeparatedTokenPropertyList.split(",\\s*");
        }

        public String getTokenPropertyFeatures() {
            return StringUtil.toString(this.tokenPropertyFeatures);
        }

        public void setTokenPropertyFeatures(Set<String> propertySet) {
            this.tokenPropertyFeatures = propertySet.toArray(new String[propertySet.size()]);
        }

        @Override
        public void extractFeatures(Span s) {
            this.extractFeatures(new EmptyLabels(), s);
        }

        @Override
        public void extractFeatures(TextLabels labels, Span s) {
            this.requireMyAnnotation(labels);
            if (this.tokenPropertyFeatures == null) {
                System.out.println("setTokenPropertyFeatures to the set " + labels.getTokenProperties());
                this.setTokenPropertyFeatures(labels.getTokenProperties());
            }
            this.from(s).tokens().eq().lc().emit();
            if (this.useCompressedCharType) {
                this.from(s).tokens().eq().charTypePattern().emit();
            }
            if (this.useCharType) {
                this.from(s).tokens().eq().charTypes().emit();
            }
            for (int j = 0; j < this.tokenPropertyFeatures.length; ++j) {
                this.from(s).tokens().prop(this.tokenPropertyFeatures[j]).emit();
            }
            for (int i = 0; i < this.windowSize; ++i) {
                this.from(s).left().token(-i - 1).eq().lc().emit();
                this.from(s).right().token(i).eq().lc().emit();
                for (int j = 0; j < this.tokenPropertyFeatures.length; ++j) {
                    this.from(s).left().token(-i - 1).prop(this.tokenPropertyFeatures[j]).emit();
                    this.from(s).right().token(i).prop(this.tokenPropertyFeatures[j]).emit();
                }
                if (this.useCompressedCharType) {
                    this.from(s).left().token(-i - 1).eq().charTypePattern().emit();
                    this.from(s).right().token(i).eq().charTypePattern().emit();
                }
                if (!this.useCharType) continue;
                this.from(s).left().token(-i - 1).eq().charTypes().emit();
                this.from(s).right().token(i).eq().charTypes().emit();
            }
        }
    }

    public static class BagOfLowerCaseWordsFE
    extends AnnotatedSpanFE
    implements Serializable {
        static final long serialVersionUID = 20080306L;

        public void extractFeatures(TextLabels labels, Span s) {
            this.from(s).tokens().eq().lc().emit();
        }
    }

    public static class BagOfWordsFE
    extends AnnotatedSpanFE
    implements Serializable {
        static final long serialVersionUID = 20080306L;

        public void extractFeatures(TextLabels labels, Span s) {
            this.from(s).tokens().emit();
        }
    }
}

