/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.mixup;

import edu.cmu.minorthird.text.mixup.Mixup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statement
implements Serializable {
    private static final long serialVersionUID = 20080303L;
    private static Logger log = Logger.getLogger(Statement.class);
    public static int REGEX = 1;
    public static int MIXUP = 2;
    public static int FILTER = 3;
    public static int PROVIDE = 4;
    public static int REQUIRE = 5;
    public static int DECLARE = 6;
    public static int TRIE = 7;
    public static int ANNOTATE_WITH = 8;
    private String keyword;
    private String property;
    private String type;
    private String startType;
    private String value;
    private Set<String> wordSet = null;
    private boolean ignoreCase;
    private String split;
    private String patt;
    private String level;
    private String importLevel;
    private String importType;
    private String oldType;
    private int statementType;
    private Mixup mixupExpr = null;
    private List<String> phraseList;
    private String regex = null;
    private int regexGroup;
    private String annotationType;
    private String fileToLoad;
    private List<String> filesToLoad;
    private int lastTokenStart;
    private String input;
    private static Set<String> generatorStart = new HashSet<String>();
    private static Set<String> legalKeywords = new HashSet<String>();
    private static Set<String> colonEqualsOrCase = new HashSet<String>();
    private static Set<String> defLevelType = new HashSet<String>();

    Statement(Mixup.MixupTokenizer tok, String firstTok) throws Mixup.ParseException {
        this.keyword = firstTok;
        if (this.keyword.equals("declareSpanType")) {
            this.statementType = DECLARE;
            this.type = tok.advance(null);
            tok.advance(null);
            return;
        }
        if (this.keyword.equals("provide")) {
            this.statementType = PROVIDE;
            this.annotationType = tok.advance(null);
            if (this.annotationType.charAt(0) == '\'') {
                this.annotationType = this.annotationType.substring(1, this.annotationType.length() - 1);
            }
            tok.advance(null);
            return;
        }
        if (this.keyword.equals("annotateWith")) {
            this.statementType = ANNOTATE_WITH;
            this.fileToLoad = tok.advance(null);
            if (this.fileToLoad.charAt(0) == '\'') {
                this.fileToLoad = this.fileToLoad.substring(1, this.fileToLoad.length() - 1);
            }
            tok.advance(null);
            return;
        }
        if (this.keyword.equals("require")) {
            this.statementType = REQUIRE;
            this.annotationType = tok.advance(null);
            if (this.annotationType.charAt(0) == '\'') {
                this.annotationType = this.annotationType.substring(1, this.annotationType.length() - 1);
            }
            String marker = tok.advance(null);
            log.debug("marker: " + marker);
            if (marker != null) {
                this.fileToLoad = tok.advance(null);
                if (this.fileToLoad.charAt(0) == '\'') {
                    this.fileToLoad = this.fileToLoad.substring(1, this.fileToLoad.length() - 1);
                }
                tok.advance(null);
            }
            return;
        }
        if ("onLevel".equals(this.keyword) || "offLevel".equals(this.keyword)) {
            this.level = tok.advance(null);
            tok.advance(null);
            return;
        }
        if ("importFromLevel".equals(this.keyword)) {
            this.importLevel = tok.advance(null);
            this.importType = tok.advance(null);
            tok.advance(Collections.singleton("="));
            this.oldType = tok.advance(null);
            tok.advance(null);
            return;
        }
        String propOrType = tok.advance(null);
        String token = tok.advance(colonEqualsOrCase);
        if (":".equals(token)) {
            if (!"defSpanProp".equals(this.keyword) && !"defTokenProp".equals(this.keyword)) {
                this.parseError("can't define properties here");
            }
            this.property = propOrType;
            this.type = null;
            this.value = tok.advance(null);
            tok.advance(Collections.singleton("="));
        } else if ("case".equals(token)) {
            if (!"defDict".equals(this.keyword)) {
                this.parseError("illegal keyword usage");
            }
        } else {
            if (!("defSpanType".equals(this.keyword) || "defDict".equals(this.keyword) || "defLevel".equals(this.keyword))) {
                this.parseError("illegal keyword usage");
            }
            if (!"=".equals(token)) {
                this.parseError("expected '='");
            }
            this.type = propOrType;
            this.property = null;
        }
        if ("defDict".equals(this.keyword)) {
            this.ignoreCase = true;
            if ("case".equals(token)) {
                this.ignoreCase = false;
                if (!"+".equals(propOrType)) {
                    this.parseError("illegal defDict");
                }
                this.type = tok.advance(null);
                tok.advance(Collections.singleton("="));
            } else {
                this.type = propOrType;
            }
            this.wordSet = new HashSet<String>();
            this.filesToLoad = new ArrayList<String>();
            while (true) {
                String w;
                if ((w = tok.advance(null)).equals("\"")) {
                    StringBuffer defFile = new StringBuffer("");
                    while (!(w = tok.advance(null)).equals("\"")) {
                        defFile.append(w);
                    }
                    this.fileToLoad = defFile.toString();
                    this.filesToLoad.add(this.fileToLoad);
                } else {
                    this.wordSet.add(this.ignoreCase ? w.toLowerCase() : w);
                }
                String sep = tok.advance(null);
                if (sep != null) {
                    if (",".equals(sep)) continue;
                    this.parseError("expected comma");
                    continue;
                }
                break;
            }
        } else if ("defLevel".equals(this.keyword)) {
            this.split = tok.advance(defLevelType);
            this.patt = tok.advance(null);
            if (this.patt.charAt(0) == '\'' && this.patt.charAt(this.patt.length() - 1) == '\'') {
                this.patt = this.patt.substring(1, this.patt.length() - 1);
            }
            tok.advance(null);
        } else {
            token = tok.advance(null);
            if (generatorStart.contains(token)) {
                this.startType = "top";
            } else {
                this.startType = token;
                token = tok.advance(generatorStart);
            }
            if (token.equals(":")) {
                this.statementType = MIXUP;
                if (tok.advance()) {
                    this.mixupExpr = new Mixup(tok);
                }
            } else if (token.equals("-")) {
                this.statementType = FILTER;
                if (tok.advance()) {
                    this.mixupExpr = new Mixup(tok);
                }
            } else if (token.equals("~")) {
                token = tok.advance(null);
                if ("re".equals(token)) {
                    this.statementType = REGEX;
                    this.regex = tok.advance(null);
                    if (this.regex.startsWith("'")) {
                        this.regex = this.regex.substring(1, this.regex.length() - 1);
                        this.regex = this.regex.replaceAll("\\\\'", "'");
                    }
                    token = tok.advance(Collections.singleton(","));
                    token = tok.advance(null);
                    try {
                        this.regexGroup = Integer.parseInt(token);
                        token = tok.advance(null);
                    }
                    catch (NumberFormatException e) {
                        this.parseError("expected a regex group number and saw " + token);
                    }
                } else if ("trie".equals(token)) {
                    this.statementType = TRIE;
                    this.phraseList = new ArrayList<String>();
                    String word = tok.advance(null);
                    word.trim();
                    String fullWord = "";
                    while (word != null) {
                        if (!word.equals(",")) {
                            fullWord = fullWord + word + " ";
                        } else {
                            fullWord.trim();
                            this.phraseList.add(fullWord);
                            fullWord = "";
                        }
                        word = tok.advance(null);
                    }
                    this.phraseList.add(fullWord);
                } else {
                    this.parseError("expected 're' or 'trie'");
                }
            } else {
                throw new IllegalStateException("unexpected generatorStart '" + token + "'");
            }
        }
    }

    private String parseError(String msg) throws Mixup.ParseException {
        throw new Mixup.ParseException("statement error at char " + this.lastTokenStart + ": " + msg + "\nin '" + this.input + "'");
    }

    public String toString() {
        if ("defDict".equals(this.keyword) || "defLevel".equals(this.keyword)) {
            return this.keyword + " " + this.type + " = ... ";
        }
        if ("onLevel".equals(this.keyword) || "offLevel".equals(this.keyword)) {
            return this.keyword + " " + this.level;
        }
        if ("importFromLevel".equals(this.keyword)) {
            return this.keyword + " " + this.importLevel + " " + this.importType + " = " + this.oldType;
        }
        if (this.statementType == DECLARE) {
            return this.keyword + " " + this.type;
        }
        if (this.statementType == PROVIDE) {
            return this.keyword + " " + this.annotationType;
        }
        if (this.statementType == REQUIRE) {
            return this.keyword + " " + this.annotationType + "," + this.fileToLoad;
        }
        if (this.statementType == ANNOTATE_WITH) {
            return this.keyword + " " + this.fileToLoad;
        }
        String genString = "???";
        if (this.statementType == MIXUP) {
            genString = ": " + this.mixupExpr.toString();
        } else if (this.statementType == FILTER) {
            genString = "- " + this.mixupExpr.toString();
        } else if (this.statementType == REGEX) {
            genString = "~ re '" + this.regex + "' ," + this.regexGroup;
        } else if (this.statementType == TRIE) {
            genString = "~ trie ...";
        }
        if (this.type != null) {
            return this.keyword + " " + this.type + " =" + this.startType + genString;
        }
        return this.keyword + " " + this.property + ":" + this.value + " =" + this.startType + genString;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public List<String> getFilesToLoad() {
        return this.filesToLoad;
    }

    public String getFileToLoad() {
        return this.fileToLoad;
    }

    public String getType() {
        return this.type;
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public Set<String> getWordSet() {
        return this.wordSet;
    }

    public String getSplit() {
        return this.split;
    }

    public String getPatt() {
        return this.patt;
    }

    public String getLevel() {
        return this.level;
    }

    public String getOldType() {
        return this.oldType;
    }

    public String getImportType() {
        return this.importType;
    }

    public String getImportLevel() {
        return this.importLevel;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public String getStartType() {
        return this.startType;
    }

    public Mixup getMixupExpr() {
        return this.mixupExpr;
    }

    public List<String> getPhraseList() {
        return this.phraseList;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getRegexGroup() {
        return this.regexGroup;
    }

    static {
        legalKeywords.add("defTokenProp");
        legalKeywords.add("defSpanProp");
        legalKeywords.add("defSpanType");
        legalKeywords.add("defDict");
        legalKeywords.add("declareSpanType");
        legalKeywords.add("provide");
        legalKeywords.add("require");
        legalKeywords.add("defLevel");
        legalKeywords.add("onLevel");
        legalKeywords.add("offLevel");
        legalKeywords.add("importFromLevel");
        colonEqualsOrCase.add(":");
        colonEqualsOrCase.add("=");
        colonEqualsOrCase.add("case");
        generatorStart.add(":");
        generatorStart.add("~");
        generatorStart.add("-");
        defLevelType.add("re");
        defLevelType.add("split");
        defLevelType.add("filter");
        defLevelType.add("pseudotoken");
    }
}

