/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.gui.MixupDebugger;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.File;

public class DebugMixup
extends UIMain {
    private CommandLineUtil.EditParams edit = new CommandLineUtil.EditParams();
    private CommandLineUtil.MixupParams mixup = new CommandLineUtil.MixupParams();
    public MonotonicTextLabels debuggerOutputLabels = null;

    public CommandLineUtil.MixupParams getMixupParameters() {
        return this.mixup;
    }

    public void setMixupParameters(CommandLineUtil.MixupParams p) {
        this.mixup = p;
    }

    public CommandLineUtil.EditParams getEditParameters() {
        return this.edit;
    }

    public void setEditParameters(CommandLineUtil.EditParams p) {
        this.edit = p;
    }

    public String getDebugMixupHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/Mixup%20Tutorial.htm\">Mixup Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.edit, this.mixup});
    }

    public void doMain() {
        if (this.mixup.fileName == null) {
            throw new IllegalArgumentException("need to specify -mixup");
        }
        if (this.edit.editFile == null) {
            throw new IllegalArgumentException("need to specify -edit");
        }
        this.debuggerOutputLabels = new NestedTextLabels(this.base.labels);
        MixupDebugger debugger = MixupDebugger.debug(this.base.labels.getTextBase(), this.debuggerOutputLabels, this.edit.editFile, new File(this.mixup.fileName));
        if (this.edit.extractedType != null) {
            debugger.getEditor().getViewer().getGuessBox().setSelectedItem(this.edit.extractedType);
        }
        if (this.edit.trueType != null) {
            debugger.getEditor().getViewer().getTruthBox().setSelectedItem(this.edit.trueType);
        }
        if (this.base.showResult) {
            new ViewerFrame("Output of " + this.mixup.fileName, new SmartVanillaViewer(this.debuggerOutputLabels));
        }
    }

    public Object getMainResult() {
        return this.debuggerOutputLabels;
    }

    public static void main(String[] args) {
        new DebugMixup().callMain(args);
    }
}

