/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.text.learn.OnlineBinaryTextClassifierLearner;
import edu.cmu.minorthird.text.learn.OnlineTextClassifierLearner;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import java.io.IOException;

public class OnlineLearner
extends UIMain {
    protected CommandLineUtil.OnlineBaseParams labeledData = new CommandLineUtil.OnlineBaseParams();
    private CommandLineUtil.OnlineSignalParams signal = new CommandLineUtil.OnlineSignalParams(this.labeledData);
    private CommandLineUtil.TrainClassifierParams train = new CommandLineUtil.TrainClassifierParams();
    private CommandLineUtil.TestClassifierParams test = new CommandLineUtil.TestClassifierParams();
    OnlineTextClassifierLearner textLearner = null;

    public CommandLineUtil.OnlineBaseParams get_LabeledDataParameters() {
        return this.labeledData;
    }

    public void set_LabeledDataParameters(CommandLineUtil.OnlineBaseParams labeledData) {
        this.labeledData = labeledData;
    }

    public CommandLineUtil.OnlineSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.OnlineSignalParams p) {
        this.signal = p;
    }

    public CommandLineUtil.TrainClassifierParams getAdditionalParameters() {
        return this.train;
    }

    public void setAdditionalParameters(CommandLineUtil.TrainClassifierParams p) {
        this.train = p;
    }

    public CommandLineUtil.TestClassifierParams getTextLearnerParameters() {
        return this.test;
    }

    public void setTextLearnerParameters(CommandLineUtil.TestClassifierParams p) {
        this.test = p;
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.labeledData, this.signal, this.train, this.test});
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.signal.spanType == null) {
            throw new IllegalArgumentException("-spanType must be specified");
        }
        if (!(this.train.learner instanceof OnlineBinaryClassifierLearner)) {
            throw new IllegalArgumentException("The learner must be an OnlineBinaryClassifierLearner");
        }
        if (this.test.loadFrom == null) {
            this.textLearner = new OnlineBinaryTextClassifierLearner((OnlineClassifierLearner)this.train.learner, this.signal.spanType, this.labeledData.labeledData, this.train.fe);
        } else {
            try {
                OnlineBinaryTextClassifierLearner obtcl = (OnlineBinaryTextClassifierLearner)IOUtil.loadSerialized(this.test.loadFrom);
                this.textLearner = obtcl;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("can't load annotator from " + this.test.loadFrom + ": " + ex);
            }
        }
    }

    public Object getMainResult() {
        return this.textLearner.getClassifier();
    }

    public static void main(String[] args) {
        new OnlineLearner().callMain(args);
    }
}

