/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.BatchVersion;
import edu.cmu.minorthird.classify.algorithms.linear.VotedPerceptron;
import edu.cmu.minorthird.classify.algorithms.trees.AdaBoost;
import edu.cmu.minorthird.classify.sequential.CMMLearner;
import edu.cmu.minorthird.classify.sequential.CRFLearner;
import edu.cmu.minorthird.classify.sequential.CollinsPerceptronLearner;
import edu.cmu.minorthird.classify.sequential.HMMLearner;
import edu.cmu.minorthird.classify.sequential.SegmentCRFLearner;
import edu.cmu.minorthird.classify.sequential.SegmentCollinsPerceptronLearner;
import edu.cmu.minorthird.classify.transform.TFIDFTransformLearner;
import edu.cmu.minorthird.classify.transform.TransformingBatchLearner;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.BeginContinueEndUniqueReduction;
import edu.cmu.minorthird.text.learn.ConditionalSemiMarkovModel;
import edu.cmu.minorthird.text.learn.InsideOutsideReduction;
import edu.cmu.minorthird.text.learn.SegmentAnnotatorLearner;
import edu.cmu.minorthird.text.learn.SequenceAnnotatorLearner;
import edu.cmu.minorthird.text.learn.SpanFE;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.StringUtil;
import java.io.Serializable;
import java.util.Set;
import org.apache.log4j.Logger;

public class Recommended {
    private static Logger log = Logger.getLogger(Recommended.class);

    public static class MultitokenSpanFE
    extends TokenFE
    implements CommandLineProcessor.Configurable,
    Serializable {
        static final long serialVersionUID = 20080517L;
        private boolean useFirst = true;
        private boolean useLast = true;
        private boolean useLength = true;
        private boolean useInternal = true;

        public void setUseFirst(boolean flag) {
            this.useFirst = flag;
        }

        public boolean getUseFirst() {
            return this.useFirst;
        }

        public void setUseLast(boolean flag) {
            this.useLast = flag;
        }

        public boolean getUseLast() {
            return this.useLast;
        }

        public void setUseLength(boolean flag) {
            this.useLength = flag;
        }

        public boolean getUseLength() {
            return this.useLength;
        }

        public void setUseInternal(boolean flag) {
            this.useInternal = flag;
        }

        public boolean getUseInternal() {
            return this.useInternal;
        }

        public CommandLineProcessor getCLP() {
            return new JointCommandLineProcessor(new CommandLineProcessor[]{super.getCLP(), new MyCLP()});
        }

        public void extractFeatures(TextLabels labels, Span span) {
            super.extractFeatures(labels, span);
            if (this.useInternal) {
                this.from(span).eq().lc().emit();
                if (this.useCharType) {
                    this.from(span).eq().charTypes().emit();
                }
                if (this.useCharTypePattern) {
                    this.from(span).eq().charTypePattern().emit();
                }
            }
            if (this.useLength) {
                this.from(span).size().emit();
                this.from(span).exactSize().emit();
            }
            if (this.useFirst) {
                this.from(span).token(0).eq().lc().emit();
            }
            if (this.useLast) {
                this.from(span).token(-1).eq().lc().emit();
            }
            if (this.useCharType) {
                if (this.useFirst) {
                    this.from(span).token(0).eq().charTypes().lc().emit();
                }
                if (this.useLast) {
                    this.from(span).token(-1).eq().charTypes().lc().emit();
                }
            }
            if (this.useCharTypePattern) {
                if (this.useFirst) {
                    this.from(span).token(0).eq().charTypePattern().lc().emit();
                }
                if (this.useLast) {
                    this.from(span).token(-1).eq().charTypePattern().lc().emit();
                }
            }
            for (int i = 0; i < this.tokenPropertyFeatures.length; ++i) {
                String p = this.tokenPropertyFeatures[i];
                if (this.useFirst) {
                    this.from(span).token(0).prop(p).emit();
                }
                if (!this.useLast) continue;
                this.from(span).token(-1).prop(p).emit();
            }
        }

        public class MyCLP
        extends BasicCommandLineProcessor {
            public void first() {
                MultitokenSpanFE.this.useFirst = true;
            }

            public void noFirst() {
                MultitokenSpanFE.this.useFirst = false;
            }

            public void last() {
                MultitokenSpanFE.this.useLast = true;
            }

            public void noLast() {
                MultitokenSpanFE.this.useLast = false;
            }

            public void length() {
                MultitokenSpanFE.this.useLength = true;
            }

            public void noLength() {
                MultitokenSpanFE.this.useLength = false;
            }

            public void internal() {
                MultitokenSpanFE.this.useInternal = true;
            }

            public void noInternal() {
                MultitokenSpanFE.this.useInternal = false;
            }
        }
    }

    public static class TokenFE
    extends TokenPropUsingFE
    implements CommandLineProcessor.Configurable,
    Serializable {
        static final long serialVersionUID = 20080517L;
        protected int windowSize = 3;
        protected boolean useCharType = false;
        protected boolean useCharTypePattern = true;
        protected boolean useTokenValues = true;

        public void setFeatureWindowSize(int n) {
            this.windowSize = n;
        }

        public int getFeatureWindowSize() {
            return this.windowSize;
        }

        public void setUseCharType(boolean flag) {
            this.useCharType = flag;
        }

        public boolean getUseCharType() {
            return this.useCharType;
        }

        public void setUseCharTypePattern(boolean flag) {
            this.useCharTypePattern = flag;
        }

        public boolean getUseCharTypePattern() {
            return this.useCharTypePattern;
        }

        public void setUseTokenValues(boolean flag) {
            this.useTokenValues = flag;
        }

        public boolean getUseTokenValues() {
            return this.useTokenValues;
        }

        public CommandLineProcessor getCLP() {
            return new MyCLP();
        }

        public void extractFeatures(TextLabels labels, Span s) {
            this.requireMyAnnotation(labels);
            this.setMyTokenPropertyList(labels);
            if (this.useTokenValues) {
                this.from(s).tokens().eq().lc().emit();
            }
            if (this.useCharTypePattern) {
                this.from(s).tokens().eq().charTypePattern().emit();
            }
            if (this.useCharType) {
                this.from(s).tokens().eq().charTypes().emit();
            }
            for (int j = 0; j < this.tokenPropertyFeatures.length; ++j) {
                this.from(s).tokens().prop(this.tokenPropertyFeatures[j]).emit();
            }
            for (int i = 0; i < this.windowSize; ++i) {
                if (this.useTokenValues) {
                    this.from(s).left().token(-i - 1).eq().lc().emit();
                }
                if (this.useTokenValues) {
                    this.from(s).right().token(i).eq().lc().emit();
                }
                for (int j = 0; j < this.tokenPropertyFeatures.length; ++j) {
                    this.from(s).left().token(-i - 1).prop(this.tokenPropertyFeatures[j]).emit();
                    this.from(s).right().token(i).prop(this.tokenPropertyFeatures[j]).emit();
                }
                if (this.useCharTypePattern) {
                    this.from(s).left().token(-i - 1).eq().charTypePattern().emit();
                    this.from(s).right().token(i).eq().charTypePattern().emit();
                }
                if (!this.useCharType) continue;
                this.from(s).left().token(-i - 1).eq().charTypes().emit();
                this.from(s).right().token(i).eq().charTypes().emit();
            }
        }

        public class MyCLP
        extends BasicCommandLineProcessor {
            public void window(String s) {
                TokenFE.this.windowSize = StringUtil.atoi(s);
                System.out.println("window=>" + s);
            }

            public void charTypes() {
                TokenFE.this.useCharType = true;
            }

            public void noCharTypes() {
                TokenFE.this.useCharType = false;
            }

            public void charTypePattern() {
                TokenFE.this.useCharTypePattern = true;
            }

            public void noCharTypePattern() {
                TokenFE.this.useCharTypePattern = false;
            }

            public void noTokenValues() {
                TokenFE.this.useTokenValues = false;
            }

            public void tokenProps(String s) {
                TokenFE.this.setTokenPropertyFeatures(s);
            }
        }
    }

    public static class DocumentFE
    extends TokenPropUsingFE
    implements Serializable {
        static final long serialVersionUID = 20080517L;
        protected boolean foldCase = true;

        public void extractFeatures(TextLabels labels, Span s) {
            this.requireMyAnnotation(labels);
            this.setMyTokenPropertyList(labels);
            if (this.foldCase) {
                this.from(s).tokens().eq().lc().emit();
            } else {
                this.from(s).tokens().eq().emit();
            }
            for (int j = 0; j < this.tokenPropertyFeatures.length; ++j) {
                this.from(s).tokens().prop(this.tokenPropertyFeatures[j]).emit();
            }
        }

        public boolean getFoldCase() {
            return this.foldCase;
        }

        public void setFoldCase(boolean flag) {
            this.foldCase = flag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TokenPropUsingFE
    extends SpanFE
    implements Serializable {
        protected String[] tokenPropertyFeatures = null;

        @Override
        public void setRequiredAnnotation(String requiredAnnotation, String annotationProvider) {
            super.setRequiredAnnotation(requiredAnnotation, annotationProvider);
            this.tokenPropertyFeatures = null;
        }

        public void setTokenPropertyFeatures(String commaSeparatedTokenPropertyList) {
            this.tokenPropertyFeatures = "*".equals(commaSeparatedTokenPropertyList) ? null : commaSeparatedTokenPropertyList.split(",\\s*");
        }

        public String getTokenPropertyFeatures() {
            return this.tokenPropertyFeatures == null ? "*" : StringUtil.toString(this.tokenPropertyFeatures);
        }

        public void setTokenPropertyFeatures(Set<String> propertySet) {
            this.tokenPropertyFeatures = propertySet.toArray(new String[propertySet.size()]);
        }

        protected void setMyTokenPropertyList(TextLabels labels) {
            if (this.tokenPropertyFeatures == null) {
                log.info("tokenPropertyFeatures: " + labels.getTokenProperties());
                this.setTokenPropertyFeatures(labels.getTokenProperties());
            }
        }
    }

    public static class VPTagLearner
    extends CollinsPerceptronLearner {
        public VPTagLearner() {
            super(1, 5);
        }
    }

    public static class HMMTokenFE
    extends TokenPropUsingFE
    implements CommandLineProcessor.Configurable,
    Serializable {
        static final long serialVersionUID = 20080517L;
        protected boolean useCharType = false;
        protected boolean useCharTypePattern = true;

        public void setUseCharType(boolean flag) {
            this.useCharType = flag;
        }

        public boolean getUseCharType() {
            return this.useCharType;
        }

        public void setUseCharTypePattern(boolean flag) {
            this.useCharTypePattern = flag;
        }

        public boolean getUseCharTypePattern() {
            return this.useCharTypePattern;
        }

        public CommandLineProcessor getCLP() {
            return new MyCLP();
        }

        public void extractFeatures(TextLabels labels, Span s) {
            this.requireMyAnnotation(labels);
            this.setMyTokenPropertyList(labels);
            this.from(s).tokens().eq().emit();
        }

        public class MyCLP
        extends BasicCommandLineProcessor {
            public void charTypes() {
                HMMTokenFE.this.useCharType = true;
            }

            public void noCharTypes() {
                HMMTokenFE.this.useCharType = false;
            }

            public void charTypePattern() {
                HMMTokenFE.this.useCharTypePattern = true;
            }

            public void noCharTypePattern() {
                HMMTokenFE.this.useCharTypePattern = false;
            }

            public void tokenProps(String s) {
                HMMTokenFE.this.setTokenPropertyFeatures(s);
            }
        }
    }

    public static class HMMAnnotatorLearner
    extends SequenceAnnotatorLearner {
        public HMMAnnotatorLearner() {
            super(new HMMLearner(), new HMMTokenFE(), new InsideOutsideReduction());
        }
    }

    public static class SemiCRFAnnotatorLearner
    extends SegmentAnnotatorLearner {
        public SemiCRFAnnotatorLearner() {
            super(new SegmentCRFLearner(""), new MultitokenSpanFE(), 4);
        }

        public SemiCRFAnnotatorLearner(int maxIters, int maxLen) {
            super(new SegmentCRFLearner("maxIters " + maxIters), new MultitokenSpanFE(), maxLen);
        }
    }

    public static class CRFAnnotatorLearner
    extends SequenceAnnotatorLearner {
        public CRFAnnotatorLearner() {
            super(new CRFLearner(), new TokenFE(), new BeginContinueEndUniqueReduction());
        }
    }

    public static class SVMCMMLearner
    extends SequenceAnnotatorLearner {
        public SVMCMMLearner() {
            super(new CMMLearner(new SVMLearner(), 1), new TokenFE());
        }
    }

    public static class VPCMMLearner
    extends SequenceAnnotatorLearner {
        public VPCMMLearner() {
            super(new CMMLearner(new VotedPerceptronLearner(), 1), new TokenFE());
        }
    }

    public static class MEMMLearner
    extends SequenceAnnotatorLearner {
        public MEMMLearner() {
            super(new CMMLearner(new MaxEntLearner(), 1), new TokenFE());
        }
    }

    public static class VPHMMLearner
    extends SequenceAnnotatorLearner {
        public VPHMMLearner() {
            super(new CollinsPerceptronLearner(1, 5), new TokenFE());
        }
    }

    public static class VPSMMLearner2
    extends SegmentAnnotatorLearner {
        private static final long serialVersionUID = 1L;

        public VPSMMLearner2() {
            super(new SegmentCollinsPerceptronLearner(), new MultitokenSpanFE(), 4);
        }

        public VPSMMLearner2(int epochs, int maxLen) {
            super(new SegmentCollinsPerceptronLearner(epochs), new MultitokenSpanFE(), maxLen);
        }
    }

    public static class VPSMMLearner
    extends ConditionalSemiMarkovModel.CSMMLearner {
        private static final long serialVersionUID = 1L;

        public VPSMMLearner() {
            super(20, 4);
        }

        public VPSMMLearner(int maxLength) {
            super(20, maxLength);
        }
    }

    public static class BoostedStumpLearner
    extends AdaBoost {
        public BoostedStumpLearner() {
            super(new edu.cmu.minorthird.classify.algorithms.trees.DecisionTreeLearner(), 100);
        }
    }

    public static class BoostedDecisionTreeLearner
    extends AdaBoost {
        public BoostedDecisionTreeLearner() {
            super(new DecisionTreeLearner(), 10);
        }
    }

    public static class DecisionTreeLearner
    extends edu.cmu.minorthird.classify.algorithms.trees.DecisionTreeLearner {
    }

    public static class CascadingBinaryLearner
    extends edu.cmu.minorthird.classify.CascadingBinaryLearner {
        public CascadingBinaryLearner() {
            super(new MaxEntLearner());
        }
    }

    public static class MostFrequentFirstLearner
    extends edu.cmu.minorthird.classify.MostFrequentFirstLearner {
        public MostFrequentFirstLearner() {
            super(new MaxEntLearner());
        }
    }

    public static class OneVsAllLearner
    extends edu.cmu.minorthird.classify.OneVsAllLearner {
        public OneVsAllLearner() {
            super(new MaxEntLearner());
        }
    }

    public static class MaxEntLearner
    extends edu.cmu.minorthird.classify.algorithms.linear.MaxEntLearner {
        public MaxEntLearner() {
            super("maxIters 50");
        }
    }

    public static class SVMLearner
    extends edu.cmu.minorthird.classify.algorithms.svm.SVMLearner {
    }

    public static class VotedPerceptronLearner
    extends BatchVersion {
        public VotedPerceptronLearner() {
            super(new VotedPerceptron(), 5);
        }
    }

    public static class TweakedLearner
    extends edu.cmu.minorthird.classify.TweakedLearner {
        public TweakedLearner() {
            super(new NaiveBayes(), 1.0);
        }
    }

    public static class NaiveBayes
    extends edu.cmu.minorthird.classify.algorithms.linear.NaiveBayes {
        static final long serialVersionUID = 20080517L;
    }

    public static class KnnLearner
    extends TransformingBatchLearner {
        public KnnLearner() {
            super(new TFIDFTransformLearner(), new BatchVersion(new edu.cmu.minorthird.classify.algorithms.knn.KnnLearner(30), 1));
        }
    }
}

