/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.multi.MultiClassifiedDataset;
import edu.cmu.minorthird.classify.multi.MultiClassifier;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiEvaluation;
import edu.cmu.minorthird.classify.transform.AbstractInstanceTransform;
import edu.cmu.minorthird.classify.transform.TransformingMultiClassifier;
import edu.cmu.minorthird.text.learn.MultiClassifierAnnotator;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;
import java.io.Serializable;

public class TestMultiClassifier
extends UIMain {
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.MultiClassificationSignalParams signal = new CommandLineUtil.MultiClassificationSignalParams(this.base);
    private CommandLineUtil.TestClassifierParams test = new CommandLineUtil.TestClassifierParams();
    private Object result = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.MultiClassificationSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.MultiClassificationSignalParams p) {
        this.signal = p;
    }

    public CommandLineUtil.TestClassifierParams getAdditionalParameters() {
        return this.test;
    }

    public void setAdditionalParameters(CommandLineUtil.TestClassifierParams p) {
        this.test = p;
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.test});
    }

    public void doMain() {
        if (this.test.loadFrom == null) {
            throw new IllegalArgumentException("-loadFrom must be specified");
        }
        MultiClassifierAnnotator ann = null;
        try {
            ann = (MultiClassifierAnnotator)IOUtil.loadSerialized(this.test.loadFrom);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't load annotator from " + this.test.loadFrom + ": " + ex);
        }
        MultiDataset d = CommandLineUtil.toMultiDataset(this.base.labels, ann.getFE(), this.signal.multiSpanProp);
        MultiClassifier multiClassifier = ann.getMultiClassifier();
        if (this.signal.cross) {
            if (multiClassifier instanceof TransformingMultiClassifier) {
                AbstractInstanceTransform transformer = ((TransformingMultiClassifier)multiClassifier).getTransform();
                d = transformer.transform(d);
            } else {
                throw new IllegalArgumentException("Must be a TransformingMultiClassifier to use cross dimensions");
            }
        }
        MultiEvaluation evaluation = null;
        if (this.test.showData) {
            new ViewerFrame("Dataset", d.toGUI());
        }
        if (this.test.showClassifier) {
            new ViewerFrame("Classifier", new SmartVanillaViewer(multiClassifier));
        }
        evaluation = new MultiEvaluation(d.getMultiSchema());
        evaluation.extend(multiClassifier, d);
        this.result = this.test.showTestDetails ? new MultiClassifiedDataset(multiClassifier, d) : evaluation;
        if (this.base.showResult) {
            new ViewerFrame("Result", new SmartVanillaViewer(this.result));
        }
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized((Serializable)((Object)evaluation), this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
        evaluation.summarize();
    }

    public Object getMainResult() {
        return this.result;
    }

    public static void main(String[] args) {
        new TestMultiClassifier().callMain(args);
    }
}

