/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.learn.TextLabelsAnnotatorTeacher;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;
import java.io.Serializable;

public class TrainExtractor
extends UIMain {
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.ExtractionSignalParams signal = new CommandLineUtil.ExtractionSignalParams(this.base);
    private CommandLineUtil.TrainExtractorParams train = new CommandLineUtil.TrainExtractorParams();
    private Annotator ann = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.TrainExtractorParams getAdditionalParameters() {
        return this.train;
    }

    public void setAdditionalParameters(CommandLineUtil.TrainExtractorParams p) {
        this.train = p;
    }

    public CommandLineUtil.ExtractionSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.ExtractionSignalParams newSignal) {
        this.signal = newSignal;
    }

    public String getTrainExtractorHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/TrainExtractor%20Tutorial.htm\">TrainExtractor Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.train});
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.train.fe != null) {
            this.train.learner.setSpanFeatureExtractor(this.train.fe);
        }
        this.train.learner.setAnnotationType(this.train.output);
        TextLabelsAnnotatorTeacher teacher = new TextLabelsAnnotatorTeacher(this.base.labels, this.signal.spanType, this.signal.spanProp);
        this.ann = teacher.train(this.train.learner);
        if (this.base.showResult) {
            SmartVanillaViewer av = new SmartVanillaViewer();
            av.setContent(this.ann);
            new ViewerFrame("Extractor", av);
        }
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized((Serializable)((Object)this.ann), this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
    }

    public Object getMainResult() {
        return this.ann;
    }

    public static void main(String[] args) {
        new TrainExtractor().callMain(args);
    }
}

