/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.FixedTestSetSplitter;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.experiments.ExtractionEvaluation;
import edu.cmu.minorthird.text.learn.experiments.TextLabelsExperiment;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TrainTestExtractor
extends UIMain {
    static Logger log = Logger.getLogger(TrainTestExtractor.class);
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.ExtractionSignalParams signal = new CommandLineUtil.ExtractionSignalParams(this.base);
    private CommandLineUtil.TrainExtractorParams train = new CommandLineUtil.TrainExtractorParams();
    private CommandLineUtil.SplitterParams trainTest = new CommandLineUtil.SplitterParams();
    private Object result = null;

    public String getTrainTestExtractorHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/TrainTestExtractor%20Tutorial.htm\">TrainTestExtractor Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.train, this.trainTest});
    }

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams save) {
        this.save = save;
    }

    public CommandLineUtil.ExtractionSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.ExtractionSignalParams signal) {
        this.signal = signal;
    }

    public CommandLineUtil.TrainExtractorParams getTrainingParameters() {
        return this.train;
    }

    public void setTrainingParameters(CommandLineUtil.TrainExtractorParams train) {
        this.train = train;
    }

    public CommandLineUtil.SplitterParams getSplitterParameters() {
        return this.trainTest;
    }

    public void setSplitterParameters(CommandLineUtil.SplitterParams trainTest) {
        this.trainTest = trainTest;
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.signal.spanProp == null && this.signal.spanType == null) {
            throw new IllegalArgumentException("one of -spanProp or -spanType must be specified");
        }
        if (this.signal.spanProp != null && this.signal.spanType != null) {
            throw new IllegalArgumentException("only one of -spanProp or -spanType can be specified");
        }
        if (this.trainTest.labels != null) {
            if (this.signal.spanPropString != null) {
                CommandLineUtil.createSpanProp(this.signal.spanPropString, this.trainTest.labels);
            }
            this.trainTest.splitter = new FixedTestSetSplitter<Span>(this.trainTest.labels.getTextBase().documentSpanIterator());
            System.out.println("splitter for test size " + this.trainTest.labels.getTextBase().size() + " is " + this.trainTest.splitter);
        }
        TextLabelsExperiment expt = new TextLabelsExperiment((TextLabels)this.base.labels, (Splitter<Span>)this.trainTest.splitter, this.trainTest.labels, this.train.learner, this.signal.spanType, this.signal.spanProp, this.train.output);
        expt.doExperiment();
        ExtractionEvaluation evaluation = expt.getEvaluation();
        this.result = this.trainTest.showTestDetails ? expt : evaluation;
        if (this.base.showResult) {
            new ViewerFrame("Experimental Result", new SmartVanillaViewer(this.result));
        }
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized(evaluation, this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
    }

    public Object getMainResult() {
        return this.result;
    }

    public static void main(String[] args) {
        new TrainTestExtractor().callMain(args);
    }
}

